/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.TurtleUpgrades;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

class UpgradeContainer
implements Container {
    private static final int SIZE = 2;
    private final ITurtleAccess turtle;
    private final List<UpgradeData<ITurtleUpgrade>> lastUpgrade = Arrays.asList(null, null);
    private final NonNullList<ItemStack> lastStack = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);

    UpgradeContainer(ITurtleAccess turtle) {
        this.turtle = turtle;
    }

    private TurtleSide getSide(int slot) {
        return switch (slot) {
            case 0 -> TurtleSide.LEFT;
            case 1 -> TurtleSide.RIGHT;
            default -> throw new IllegalArgumentException("Invalid slot " + slot);
        };
    }

    public ItemStack getItem(int slot) {
        TurtleSide side = this.getSide(slot);
        UpgradeData<ITurtleUpgrade> upgrade = this.turtle.getUpgradeWithData(side);
        if (upgrade == null) {
            return ItemStack.EMPTY;
        }
        if (upgrade.equals(this.lastUpgrade.get(slot))) {
            return (ItemStack)this.lastStack.get(slot);
        }
        return this.setUpgradeStack(slot, upgrade);
    }

    private ItemStack setUpgradeStack(int slot, @Nullable UpgradeData<ITurtleUpgrade> upgrade) {
        ItemStack stack = upgrade == null ? ItemStack.EMPTY : upgrade.getUpgradeItem();
        this.lastUpgrade.set(slot, upgrade);
        this.lastStack.set(slot, (Object)stack);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        UpgradeData<ITurtleUpgrade> upgrade = TurtleUpgrades.instance().get((HolderLookup.Provider)this.turtle.getLevel().registryAccess(), itemStack);
        this.turtle.setUpgrade(this.getSide(slot), upgrade);
        this.setUpgradeStack(slot, upgrade);
    }

    public int getContainerSize() {
        return 2;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 2; ++i) {
            if (this.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack removeItem(int slot, int count) {
        return count <= 0 ? ItemStack.EMPTY : this.removeItemNoUpdate(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack current = this.getItem(slot);
        this.setItem(slot, ItemStack.EMPTY);
        return current;
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < 2; ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }
}

