/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurtlePlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TurtlePlayer.class);
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");
    private static final double MAX_REACH = 2.0;
    private final ServerPlayer player;

    private TurtlePlayer(ServerPlayer player) {
        this.player = player;
    }

    private static TurtlePlayer create(ITurtleAccess turtle) {
        ServerLevel world = (ServerLevel)turtle.getLevel();
        GameProfile profile = turtle.getOwningPlayer();
        TurtlePlayer player = new TurtlePlayer(PlatformHelper.get().createFakePlayer(world, TurtlePlayer.getProfile(profile)));
        player.setState(turtle);
        return player;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null ? profile : DEFAULT_PROFILE;
    }

    public static TurtlePlayer get(ITurtleAccess access) {
        if (!(access instanceof TurtleBrain)) {
            throw new IllegalStateException("ITurtleAccess is not a brain");
        }
        TurtleBrain brain = (TurtleBrain)access;
        TurtlePlayer player = brain.cachedPlayer;
        if (player == null || player.player.getGameProfile() != TurtlePlayer.getProfile(access.getOwningPlayer()) || player.player.level() != access.getLevel()) {
            player = brain.cachedPlayer = TurtlePlayer.create(brain);
        } else {
            player.setState(access);
        }
        return player;
    }

    public static TurtlePlayer getWithPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        turtlePlayer.setPosition(turtle, position, direction);
        return turtlePlayer;
    }

    public ServerPlayer player() {
        return this.player;
    }

    private void setRotation(float y, float x) {
        this.player.setYRot(y);
        this.player.setXRot(x);
    }

    private void setState(ITurtleAccess turtle) {
        if (this.player.containerMenu != this.player.inventoryMenu) {
            LOGGER.warn("Turtle has open container ({})", (Object)this.player.containerMenu);
            this.player.doCloseContainer();
        }
        BlockPos position = turtle.getPosition();
        this.player.setPosRaw((double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5);
        this.setRotation(turtle.getDirection().toYRot(), 0.0f);
        this.player.getInventory().clearContent();
        this.trySetAttribute((Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, 2.0);
        this.trySetAttribute((Holder<Attribute>)Attributes.ENTITY_INTERACTION_RANGE, 2.0);
    }

    private void trySetAttribute(Holder<Attribute> attribute, double value) {
        AttributeInstance instance = this.player.getAttribute(attribute);
        if (instance != null) {
            instance.setBaseValue(value);
        }
    }

    public void setPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        double posX = (double)position.getX() + 0.5;
        double posY = (double)position.getY() + 0.5;
        double posZ = (double)position.getZ() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.getStepX();
            posY += 0.48 * (double)direction.getStepY();
            posZ += 0.48 * (double)direction.getStepZ();
        }
        if (direction.getAxis() != Direction.Axis.Y) {
            this.setRotation(direction.toYRot(), 0.0f);
        } else {
            this.setRotation(turtle.getDirection().toYRot(), DirectionUtil.toPitchAngle(direction));
        }
        this.player.setPosRaw(posX, posY, posZ);
        this.player.xo = posX;
        this.player.yo = posY;
        this.player.zo = posZ;
        this.player.xRotO = this.player.getXRot();
        this.player.yHeadRot = this.player.yRotO = this.player.getYRot();
        this.player.yHeadRotO = this.player.yRotO;
    }

    public void loadInventory(ItemStack stack) {
        this.player.getInventory().clearContent();
        this.player.getInventory().selected = 0;
        this.player.getInventory().setItem(0, stack);
    }

    public void loadInventory(ITurtleAccess turtle) {
        Inventory inventory = this.player.getInventory();
        Container turtleInventory = turtle.getInventory();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtleInventory.getContainerSize();
        inventory.selected = 0;
        inventory.clearContent();
        for (int i = 0; i < slots; ++i) {
            inventory.setItem(i, turtleInventory.getItem((currentSlot + i) % slots));
        }
    }

    public void unloadInventory(ITurtleAccess turtle) {
        if (this.player.isUsingItem()) {
            this.player.stopUsingItem();
        }
        Inventory inventory = this.player.getInventory();
        Container turtleInventory = turtle.getInventory();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtleInventory.getContainerSize();
        inventory.selected = 0;
        for (int i = 0; i < slots; ++i) {
            turtleInventory.setItem((currentSlot + i) % slots, inventory.getItem(i));
        }
        int totalSize = inventory.getContainerSize();
        for (int i = slots; i < totalSize; ++i) {
            TurtleUtil.storeItemOrDrop(turtle, inventory.getItem(i));
        }
        inventory.clearContent();
        turtleInventory.setChanged();
    }

    public boolean isBlockProtected(ServerLevel level, BlockPos pos) {
        return level.getServer().isUnderSpawnProtection(level, pos, (Player)this.player);
    }
}

