/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.lua.Coerced;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.util.StringUtil;
import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import dan200.computercraft.shared.peripheral.printer.PrinterBlockEntity;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class PrinterPeripheral
implements IPeripheral {
    private final PrinterBlockEntity printer;

    public PrinterPeripheral(PrinterBlockEntity printer) {
        this.printer = printer;
    }

    @Override
    public String getType() {
        return "printer";
    }

    @LuaFunction
    public final void write(Coerced<String> textA) throws LuaException {
        String text = textA.value();
        Terminal page = this.getCurrentPage();
        page.write(text);
        page.setCursorPos(page.getCursorX() + text.length(), page.getCursorY());
    }

    @LuaFunction
    public final Object[] getCursorPos() throws LuaException {
        Terminal page = this.getCurrentPage();
        int x = page.getCursorX();
        int y = page.getCursorY();
        return new Object[]{x + 1, y + 1};
    }

    @LuaFunction
    public final void setCursorPos(int x, int y) throws LuaException {
        Terminal page = this.getCurrentPage();
        page.setCursorPos(x - 1, y - 1);
    }

    @LuaFunction
    public final Object[] getPageSize() throws LuaException {
        Terminal page = this.getCurrentPage();
        int width = page.getWidth();
        int height = page.getHeight();
        return new Object[]{width, height};
    }

    @LuaFunction(mainThread=true)
    public final boolean newPage() {
        return this.printer.startNewPage();
    }

    @LuaFunction(mainThread=true)
    public final boolean endPage() throws LuaException {
        this.getCurrentPage();
        return this.printer.endCurrentPage();
    }

    @LuaFunction
    public final void setPageTitle(Optional<String> title) throws LuaException {
        this.getCurrentPage();
        this.printer.setPageTitle(title.map(StringUtil::normaliseLabel).orElse(""));
    }

    @LuaFunction
    public final int getInkLevel() {
        return this.printer.getInkLevel();
    }

    @LuaFunction
    public final int getPaperLevel() {
        return this.printer.getPaperLevel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable IPeripheral other) {
        if (this == other) return true;
        if (!(other instanceof PrinterPeripheral)) return false;
        PrinterPeripheral otherPrinter = (PrinterPeripheral)other;
        if (otherPrinter.printer != this.printer) return false;
        return true;
    }

    @Override
    public Object getTarget() {
        return this.printer;
    }

    private Terminal getCurrentPage() throws LuaException {
        NetworkedTerminal currentPage = this.printer.getCurrentPage();
        if (currentPage == null) {
            throw new LuaException("Page not started");
        }
        return currentPage;
    }
}

