/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.core.input.ComputerInput;
import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.codec.MoreStreamCodecs;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;

public final class KeyEventServerMessage
extends ComputerServerMessage {
    public static final StreamCodec<RegistryFriendlyByteBuf, KeyEventServerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ComputerServerMessage::containerId, MoreStreamCodecs.ofEnum(Action.class), x -> x.action, (StreamCodec)ByteBufCodecs.INT, x -> x.key, KeyEventServerMessage::new);
    private final Action action;
    private final int key;

    public KeyEventServerMessage(AbstractContainerMenu menu, Action action, int key) {
        this(menu.containerId, action, key);
    }

    private KeyEventServerMessage(int id, Action action, int key) {
        super(id);
        this.action = action;
        this.key = key;
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        ComputerInput input = container.getInput().getComputerInput();
        switch (this.action.ordinal()) {
            case 2: {
                input.keyUp(this.key);
                break;
            }
            case 0: {
                input.keyDown(this.key, false);
                break;
            }
            case 1: {
                input.keyDown(this.key, true);
                break;
            }
            case 3: {
                input.charTyped((byte)this.key);
            }
        }
    }

    public CustomPacketPayload.Type<KeyEventServerMessage> type() {
        return NetworkMessages.KEY_EVENT;
    }

    public static enum Action {
        DOWN,
        REPEAT,
        UP,
        CHAR;

    }
}

