/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.platform;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.impl.Services;
import dan200.computercraft.shared.config.ConfigFile;
import dan200.computercraft.shared.network.container.ContainerData;
import dan200.computercraft.shared.platform.ComponentAccess;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.platform.RegistrationHelper;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public interface PlatformHelper {
    public static PlatformHelper get() {
        PlatformHelper instance = Instance.INSTANCE;
        return instance == null ? Services.raise(PlatformHelper.class, Instance.ERROR) : instance;
    }

    public boolean isModLoaded(String var1);

    public ConfigFile.Builder createConfigBuilder();

    public <T> RegistrationHelper<T> createRegistrationHelper(ResourceKey<Registry<T>> var1);

    public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> I registerArgumentTypeInfo(Class<A> var1, I var2);

    public <C extends AbstractContainerMenu, T extends ContainerData> MenuType<C> createMenuType(StreamCodec<RegistryFriendlyByteBuf, T> var1, ContainerData.Factory<C, T> var2);

    public void openMenu(Player var1, Component var2, MenuConstructor var3, ContainerData var4);

    default public void invalidateComponent(BlockEntity owner) {
    }

    public ComponentAccess<IPeripheral> createPeripheralAccess(BlockEntity var1, Consumer<Direction> var2);

    public ComponentAccess<WiredElement> createWiredElementAccess(BlockEntity var1, Consumer<Direction> var2);

    public boolean hasWiredElementIn(Level var1, BlockPos var2, Direction var3);

    public ContainerTransfer.Slotted wrapContainer(Container var1);

    public @Nullable ContainerTransfer getContainer(ServerLevel var1, BlockPos var2, Direction var3);

    public RecipeIngredients getRecipeIngredients();

    public List<TagKey<Item>> getDyeTags();

    public int getBurnTime(ItemStack var1);

    public CreativeModeTab.Builder newCreativeModeTab();

    public ItemStack getCraftingRemainingItem(ItemStack var1);

    public boolean onNotifyNeighbour(Level var1, BlockPos var2, BlockState var3, Direction var4);

    public ServerPlayer createFakePlayer(ServerLevel var1, GameProfile var2);

    default public boolean isFakePlayer(ServerPlayer player) {
        return player.connection == null || player.getClass() != ServerPlayer.class;
    }

    public boolean hasToolUsage(ItemStack var1);

    public InteractionResult canAttackEntity(ServerPlayer var1, Entity var2);

    public boolean interactWithEntity(ServerPlayer var1, Entity var2, Vec3 var3);

    public UseOnResult useOn(ServerPlayer var1, ItemStack var2, BlockHitResult var3);

    public @Nullable IMedia getMedia(ItemStack var1);

    public static final class Instance {
        static final @Nullable PlatformHelper INSTANCE;
        static final @Nullable Throwable ERROR;

        private Instance() {
        }

        static {
            Services.LoadedService<PlatformHelper> helper = Services.tryLoad(PlatformHelper.class);
            INSTANCE = helper.instance();
            ERROR = helper.error();
        }
    }

    public static sealed interface UseOnResult {

        public record Continue(boolean block, boolean item) implements UseOnResult
        {
        }

        public record Handled(InteractionResult result) implements UseOnResult
        {
        }
    }
}

