/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.HolderLookup;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.converation.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiConfigSubControl;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.key.ConfigKey;
import team.creative.creativecore.common.config.premade.NamedList;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.control.simple.GuiButton;

public class ConfigTypeNamedList<T extends NamedList>
extends ConfigTypeConveration<T> {
    protected void addToList(T list, String name, Object object) {
        ((HashMap)list).put((String)name, (Object)object);
    }

    protected T create(ConfigKey key, Side side) {
        Object result = ConfigTypeConveration.createCollection(key);
        if (result != null) {
            return (T)((NamedList)result);
        }
        return (T)new NamedList();
    }

    @Override
    public T readElement(HolderLookup.Provider provider, NamedList defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey key) {
        ConfigKey listKey = ConfigKey.ofGenericType(key, side);
        T list = this.create(key, side);
        if (element.isJsonObject()) {
            JsonObject object = (JsonObject)element;
            for (Map.Entry entry : object.entrySet()) {
                listKey.read(provider, true, ignoreRestart, (JsonElement)entry.getValue(), side);
                this.addToList(list, (String)entry.getKey(), listKey.copy(provider, side));
            }
            return list;
        }
        for (Map.Entry entry : defaultValue.entrySet()) {
            listKey.forceValue(entry.getValue(), side);
            this.addToList(list, (String)entry.getKey(), listKey.copy(provider, side));
        }
        return list;
    }

    @Override
    public JsonElement writeElement(HolderLookup.Provider provider, T value, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey key) {
        JsonObject object = new JsonObject();
        ConfigKey listKey = ConfigKey.ofGenericType(key, side);
        for (Map.Entry entry : ((NamedList)value).entrySet()) {
            listKey.forceValue(entry.getValue(), side);
            object.add(entry.getKey(), listKey.write(provider, true, ignoreRestart, side));
        }
        return object;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        GuiListBoxBase listBox = (GuiListBoxBase)new GuiListBoxBase("data", true, new ArrayList()).setDim(50, 130).setExpandable();
        listBox.canBeModified = x -> !x.defaultHolder;
        parent.add((GuiControl)listBox);
        ConfigKey listKey = ConfigKey.ofGenericType(key, side);
        parent.add((GuiControl)new GuiButton("add", x -> {
            listKey.forceValue(ConfigTypeConveration.createObject(listKey.field()), side);
            GuiConfigSubControl c = listKey.create(configParent, "", side);
            c.addNameTextfield("");
            listKey.load(configParent, c, side);
            listBox.addItem(c);
        }).setTranslate("gui.add"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void restoreDefault(T value, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        this.loadValue(this.readElement(configParent.provider(), (NamedList)key.get(), true, false, this.writeElement(configParent.provider(), value, true, false, side, key), side, key), value, parent, configParent, key, side);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    public void loadValue(T value, T defaultValue, GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
        if (!box.isEmpty()) {
            box.clearItems();
        }
        ConfigKey listKey = ConfigKey.ofGenericType(key, side);
        ArrayList<GuiConfigSubControl> controls = new ArrayList<GuiConfigSubControl>(((HashMap)value).size());
        for (Map.Entry entry : ((NamedList)value).entrySet()) {
            listKey.forceValue(entry.getValue(), side);
            GuiConfigSubControl c = listKey.create(configParent, "", side);
            c.setParent(box);
            if (entry.getKey().equals("default")) {
                c.addNameUnmodifieable(entry.getKey());
            } else {
                c.addNameTextfield(entry.getKey());
            }
            listKey.load(configParent, c, side);
            c.defaultHolder = entry.getKey().equals("default");
            controls.add(c);
        }
        box.addAllItems(controls);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected T saveValue(GuiParent parent, IGuiConfigParent configParent, ConfigKey key, Side side) {
        ConfigKey listKey = ConfigKey.ofGenericType(key, side);
        GuiListBoxBase box = (GuiListBoxBase)parent.get("data");
        T value = this.create(key, side);
        for (int i = 0; i < box.size(); ++i) {
            listKey.save((GuiConfigSubControl)box.get(i), configParent, side);
            this.addToList(value, ((GuiConfigSubControl)box.get(i)).getName(), listKey.copy(configParent.provider(), side));
        }
        return value;
    }

    @Override
    public T set(ConfigKey key, T value) {
        return value;
    }

    @Override
    public boolean areEqual(T one, T two, ConfigKey key, Side side) {
        ConfigKey listKey = ConfigKey.ofGenericType(key, side);
        ConfigTypeConveration converation = listKey.converation();
        if (((HashMap)one).size() != ((HashMap)two).size()) {
            return false;
        }
        for (Map.Entry entry : ((NamedList)one).entrySet()) {
            Object other = ((LinkedHashMap)two).get(entry.getKey());
            if (converation != null) {
                listKey.forceValue(entry.getValue(), side);
                if (converation.areEqual(entry.getValue(), other, listKey, side)) continue;
                return false;
            }
            if (converation != null || key.getRegistry().equals(entry.getValue(), other, side)) continue;
            return false;
        }
        return true;
    }
}

