/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CommandShaders {
    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder main = Commands.literal((String)"clearshaders");
        main.requires(source -> source.hasPermission(4));
        main.executes(source -> CommandShaders.clearShaders((CommandContext<CommandSourceStack>)source, ((CommandSourceStack)source.getSource()).getPlayerOrException()));
        main.then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(context -> CommandShaders.clearShaders((CommandContext<CommandSourceStack>)context, EntityArgument.getPlayer((CommandContext)context, (String)"player"))));
        return main;
    }

    private static int clearShaders(CommandContext<CommandSourceStack> context, ServerPlayer player) {
        UUID uuid = player.getUUID();
        if (ShaderRegistry.receivedShaders.containsKey((Object)uuid)) {
            ShaderRegistry.receivedShaders.get((Object)uuid).clear();
        }
        ShaderRegistry.recalculatePlayerTotalWeight(uuid);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"chat.immersiveengineering.command.shaders.clear.sucess", (Object[])new Object[]{player.getName()}), true);
        return 1;
    }
}

