/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.IMutableEnergyStorage;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixerLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.mixer.MixingProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MixerMenu
extends IEContainerMenu
implements IESlot.ICallbackContainer {
    public final IEnergyStorage energy;
    public final GetterAndSetter<List<SlotProgress>> progress;
    public final GetterAndSetter<List<FluidStack>> tankContents;
    public final GetterAndSetter<Boolean> outputAll;

    public static MixerMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<MixerLogic.State> ctx) {
        MixerLogic.State state = ctx.mbContext().getState();
        GetterAndSetter<List<SlotProgress>> progress = GetterAndSetter.getterOnly(() -> {
            Level level = ctx.mbContext().getLevel().getRawLevel();
            ArrayList<SlotProgress> result = new ArrayList<SlotProgress>();
            for (MultiblockProcess process : state.processor.getQueue()) {
                if (!(process instanceof MixingProcess)) continue;
                MixingProcess inMachine = (MixingProcess)process;
                float mod = 1.0f - (float)process.processTick / (float)process.getMaxTicks(level);
                for (int inputSlot : inMachine.getInputSlots()) {
                    result.add(new SlotProgress(inputSlot, mod));
                }
            }
            return result;
        });
        return new MixerMenu(MixerMenu.multiblockCtx(type, id, ctx), invPlayer, (IItemHandler)state.getInventory(), state.energy, progress, GetterAndSetter.getterOnly(() -> state.tank.fluids), new GetterAndSetter<Boolean>(() -> state.outputAll, b -> {
            state.outputAll = b;
        }));
    }

    public static MixerMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new MixerMenu(MixerMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(8), new MutableEnergyStorage(16000), GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(List.of()), GetterAndSetter.standalone(false));
    }

    private MixerMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler inv, IMutableEnergyStorage energy, GetterAndSetter<List<SlotProgress>> progress, GetterAndSetter<List<FluidStack>> tankContents, GetterAndSetter<Boolean> outputAll) {
        super(ctx);
        int i;
        this.energy = energy;
        this.progress = progress;
        this.tankContents = tankContents;
        this.outputAll = outputAll;
        for (i = 0; i < 8; ++i) {
            this.addSlot((Slot)new IESlot.ContainerCallback(this, inv, i, 7 + i % 2 * 21, 7 + i / 2 * 18));
        }
        this.ownSlotCount = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 86 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 144));
        }
        this.addGenericData(GenericContainerData.energy(energy));
        this.addGenericData(new GenericContainerData<List<SlotProgress>>(GenericDataSerializers.MIXER_SLOTS, progress));
        this.addGenericData(new GenericContainerData<List<FluidStack>>(GenericDataSerializers.FLUID_STACKS, tankContents));
        this.addGenericData(new GenericContainerData<Boolean>(GenericDataSerializers.BOOLEAN, outputAll));
    }

    @Override
    public boolean canInsert(ItemStack stack, int slotNumber, Slot slotObject) {
        for (SlotProgress progress : this.progress.get()) {
            if (progress.slot != slotNumber) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canTake(ItemStack stack, int slotNumber, Slot slotObject) {
        return this.canInsert(stack, slotNumber, slotObject);
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.contains("outputAll", 1)) {
            this.outputAll.set(nbt.getBoolean("outputAll"));
        }
    }

    public record SlotProgress(int slot, float progress) {
        public static final StreamCodec<ByteBuf, SlotProgress> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SlotProgress::slot, (StreamCodec)ByteBufCodecs.FLOAT, SlotProgress::progress, SlotProgress::new);

        public SlotProgress(FriendlyByteBuf buf) {
            this(buf.readVarInt(), buf.readFloat());
        }

        public static void write(FriendlyByteBuf buf, SlotProgress progress) {
            buf.writeVarInt(progress.slot).writeFloat(progress.progress);
        }
    }
}

