/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.energy.WindmillBiome;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.IESounds;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class WindmillBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IPlacementInteraction,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.ISoundBE {
    public float rotation = 0.0f;
    public float turnSpeed = 0.0f;
    public int sails = 0;
    private BlockCapabilityCache<IRotationAcceptor, ?> outputCap;
    private final BiFunction<Level, Holder<Biome>, Float> biomeModifier = CachedRecipe.cached(WindmillBiome::getBiome).andThen(mod -> Float.valueOf(mod == null ? 1.0f : mod.getModifier()));
    public AABB renderAABB;
    private static final CachedVoxelShapes<Direction> SHAPES = new CachedVoxelShapes<Direction>(WindmillBlockEntity::getShape);

    public WindmillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.WINDMILL.get(), pos, state);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Direction facing = this.getFacing();
            this.outputCap = BlockCapabilityCache.create(IRotationAcceptor.CAPABILITY, (ServerLevel)serverLevel, (BlockPos)this.worldPosition.relative(facing.getOpposite()), (Object)facing);
        }
    }

    @Override
    public void tickClient() {
        this.rotation = (float)((double)this.rotation + this.getActualTurnSpeed());
        this.rotation %= 1.0f;
        ImmersiveEngineering.proxy.handleTileSound(IESounds.mill_creaking, this, this.turnSpeed > 0.0f, 0.5f, 1.0f);
    }

    public double getActualTurnSpeed() {
        if (this.turnSpeed == 0.0f) {
            return 0.0;
        }
        double mod = 5.0E-5;
        if (!this.level.isRaining()) {
            mod *= 0.75;
        }
        if (!this.level.isThundering()) {
            mod *= 0.66;
        }
        mod *= (double)this.biomeModifier.apply(this.level, (Holder<Biome>)this.level.getBiome(this.getBlockPos())).floatValue();
        return (mod *= (double)this.getSpeedModifier()) * (double)this.turnSpeed;
    }

    @Override
    public void tickServer() {
        if (this.level.getGameTime() % 128L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x7F)) {
            float oldTurnSpeed = this.turnSpeed;
            this.turnSpeed = this.computeTurnSpeed();
            if (oldTurnSpeed != this.turnSpeed) {
                this.markContainingBlockForUpdate(null);
            }
        }
        if (this.turnSpeed == 0.0f) {
            return;
        }
        IRotationAcceptor dynamo = (IRotationAcceptor)this.outputCap.getCapability();
        if (dynamo != null) {
            double power = this.getActualTurnSpeed() * 2400.0;
            dynamo.inputRotation(Math.abs(power));
        }
    }

    protected float getSpeedModifier() {
        return 0.5f + (float)this.sails * 0.125f;
    }

    public float computeTurnSpeed() {
        Direction facing = this.getFacing();
        if (facing.getAxis() == Direction.Axis.Y) {
            return 0.0f;
        }
        float turnSpeed = 0.0f;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                if (hh == 0 && ww == 0 || this.level.isEmptyBlock(this.getBlockPos().relative(facing.getClockWise(), ww).above(hh))) continue;
                return 0.0f;
            }
        }
        int blocked = 0;
        for (int hh = -4; hh <= 4; ++hh) {
            int r = Math.abs(hh) == 4 ? 1 : (Math.abs(hh) == 3 ? 2 : (Math.abs(hh) == 2 ? 3 : 4));
            for (int ww = -r; ww <= r; ++ww) {
                for (int dd = 1; dd < 8; ++dd) {
                    BlockPos pos = this.getBlockPos().above(hh).relative(facing, dd).relative(facing.getClockWise(), ww);
                    if (!this.level.isAreaLoaded(pos, 1) || this.level.isEmptyBlock(pos)) {
                        turnSpeed += 1.0f;
                        continue;
                    }
                    if (this.level.getBlockEntity(pos) instanceof WindmillBlockEntity) {
                        blocked += 20;
                        turnSpeed -= 179.0f;
                        continue;
                    }
                    ++blocked;
                }
            }
            if (blocked <= 100) continue;
            return 0.0f;
        }
        return turnSpeed;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.sails = nbt.getInt("sails");
        this.rotation = nbt.getFloat("rotation");
        this.turnSpeed = nbt.getFloat("turnSpeed");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putInt("sails", this.sails);
        nbt.putFloat("rotation", this.rotation);
        nbt.putFloat("turnSpeed", this.turnSpeed);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL_PREFER_SIDE;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.sails < 8 && heldItem.getItem() == IEItems.Ingredients.WINDMILL_SAIL.asItem()) {
            ++this.sails;
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            this.setChanged();
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        Integer blades = (Integer)stack.get(IEDataComponents.WINDMILL_BLADES);
        if (blades != null) {
            this.sails = blades;
        }
    }

    private static List<AABB> getShape(Direction key) {
        return Lists.newArrayList((Object[])new AABB[]{key.getAxis() == Direction.Axis.Z ? new AABB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 1.0) : new AABB(0.0, 0.0625, 0.0625, 1.0, 0.9375, 0.9375)});
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.getFacing());
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.turnSpeed > 0.0f;
    }
}

