/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ModWorkbenchBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IInteractionObjectIE<ModWorkbenchBlockEntity>,
IModelOffsetProvider {
    public static final BlockPos MASTER_POS = BlockPos.ZERO;
    public static final BlockPos DUMMY_POS = new BlockPos(1, 0, 0);
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)7, (Object)ItemStack.EMPTY);
    public AABB renderAABB;

    public ModWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.MOD_WORKBENCH.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        ModWorkbenchBlockEntity.applyConfigTo((ItemStack)this.inventory.get(0), message);
    }

    public static void applyConfigTo(ItemStack stack, CompoundTag message) {
        if (!(stack.getItem() instanceof IConfigurableTool)) {
            return;
        }
        for (String key : message.getAllKeys()) {
            Tag tag = message.get(key);
            if (tag instanceof ByteTag) {
                ((IConfigurableTool)stack.getItem()).applyConfigOption(stack, key, ((ByteTag)tag).getAsByte() != 0);
                continue;
            }
            if (!(tag instanceof FloatTag)) continue;
            ((IConfigurableTool)stack.getItem()).applyConfigOption(stack, key, Float.valueOf(((FloatTag)tag).getAsFloat()));
        }
    }

    @Override
    public boolean isDummy() {
        return (Boolean)this.getState().getValue((Property)IEProperties.MULTIBLOCKSLAVE);
    }

    @Override
    @Nullable
    public ModWorkbenchBlockEntity master() {
        if (!this.isDummy()) {
            return this;
        }
        if (this.tempMasterBE != null) {
            return (ModWorkbenchBlockEntity)this.tempMasterBE;
        }
        Direction dummyDir = this.isDummy() ? this.getFacing().getCounterClockWise() : this.getFacing().getClockWise();
        BlockPos masterPos = this.getBlockPos().relative(dummyDir);
        BlockEntity te = Utils.getExistingTileEntity(this.level, masterPos);
        return te instanceof ModWorkbenchBlockEntity ? (ModWorkbenchBlockEntity)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        DeskBlock.placeDummies(this.getBlockState(), this.level, this.worldPosition, ctx);
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        this.tempMasterBE = this.master();
        Direction dummyDir = this.isDummy() ? this.getFacing().getCounterClockWise() : this.getFacing().getClockWise();
        this.level.removeBlock(pos.relative(dummyDir), false);
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public ModWorkbenchBlockEntity getGuiMaster() {
        if (!this.isDummy()) {
            return this;
        }
        Direction dummyDir = this.getFacing().getCounterClockWise();
        BlockEntity tileEntityModWorkbench = this.level.getBlockEntity(this.worldPosition.relative(dummyDir));
        if (tileEntityModWorkbench instanceof ModWorkbenchBlockEntity) {
            return (ModWorkbenchBlockEntity)tileEntityModWorkbench;
        }
        return null;
    }

    @Override
    public IEMenuTypes.ArgContainer<ModWorkbenchBlockEntity, ?> getContainerType() {
        return IEMenuTypes.MOD_WORKBENCH;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return DUMMY_POS;
        }
        return MASTER_POS;
    }
}

