/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApiDataComponents;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.wooden.BlueprintShelfBlock;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BlueprintShelfBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText {
    public static final int NUM_SLOTS = 9;
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);

    public BlueprintShelfBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.BLUEPRINT_SHELF.get(), pos, state);
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_ALL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.PISTON_INVERTED_NO_DOWN;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.isShiftKeyDown();
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)provider);
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock(), 1);
        stack.set(IEDataComponents.GENERIC_ITEMS, (Object)ItemContainerContents.fromItems(this.inventory));
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        if (stack.has(IEDataComponents.GENERIC_ITEMS)) {
            this.inventory = ListUtils.fromStream(((ItemContainerContents)stack.get(IEDataComponents.GENERIC_ITEMS)).stream(), this.inventory.size());
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.getItem() instanceof EngineersBlueprintItem;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates() {
        this.setChanged();
        this.markContainingBlockForUpdate(null);
    }

    private static int getTargetedSlot(Direction side, float hitX, float hitY, float hitZ) {
        float targetU = switch (side) {
            default -> throw new MatchException(null, null);
            case Direction.SOUTH -> hitX;
            case Direction.DOWN, Direction.UP, Direction.NORTH -> 1.0f - hitX;
            case Direction.WEST -> hitZ;
            case Direction.EAST -> 1.0f - hitZ;
        };
        float targetV = side == Direction.UP ? hitZ : hitY;
        return (int)Math.floor(targetU * 3.0f) + ((double)targetV < 0.33 ? 6 : ((double)targetV < 0.66 ? 3 : 0));
    }

    @Override
    public ItemInteractionResult interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        int targetedSlot = BlueprintShelfBlockEntity.getTargetedSlot(side, hitX, hitY, hitZ);
        ItemStack stackInSlot = (ItemStack)this.inventory.get(targetedSlot);
        BlockState state = this.getLevelNonnull().getBlockState(this.getBlockPos());
        if (!stackInSlot.isEmpty()) {
            if (heldItem.isEmpty()) {
                player.setItemInHand(hand, stackInSlot);
            } else if (!this.getLevelNonnull().isClientSide()) {
                player.spawnAtLocation(stackInSlot, 0.0f);
            }
            this.inventory.set(targetedSlot, (Object)ItemStack.EMPTY);
            this.setState((BlockState)state.setValue((Property)BlueprintShelfBlock.BLUEPRINT_SLOT_FILLED[targetedSlot], (Comparable)Boolean.valueOf(false)));
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        if (this.isStackValid(targetedSlot, heldItem)) {
            this.inventory.set(targetedSlot, (Object)heldItem.copyWithCount(1));
            heldItem.shrink(1);
            this.setState((BlockState)state.setValue((Property)BlueprintShelfBlock.BLUEPRINT_SLOT_FILLED[targetedSlot], (Comparable)Boolean.valueOf(true)));
            return ItemInteractionResult.sidedSuccess((boolean)this.getLevelNonnull().isClientSide);
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    @Nullable
    public Component[] getOverlayText(@Nullable BlockState blockState, Player player, HitResult mop, boolean hammer) {
        if (mop instanceof BlockHitResult) {
            String formatted;
            BlockHitResult bhr = (BlockHitResult)mop;
            float hitX = (float)bhr.getLocation().x - (float)bhr.getBlockPos().getX();
            float hitY = (float)bhr.getLocation().y - (float)bhr.getBlockPos().getY();
            float hitZ = (float)bhr.getLocation().z - (float)bhr.getBlockPos().getZ();
            int targetedSlot = BlueprintShelfBlockEntity.getTargetedSlot(bhr.getDirection(), hitX, hitY, hitZ);
            ItemStack stackInSlot = (ItemStack)this.inventory.get(targetedSlot);
            String key = IEApiDataComponents.getBlueprintType(stackInSlot);
            if (key.isEmpty() || "invalid_blueprint".equals(key)) {
                return null;
            }
            String formatKey = "desc.immersiveengineering.info.blueprint." + key;
            if (formatKey.equals(formatted = I18n.get((String)formatKey, (Object[])new Object[0]))) {
                return new Component[]{Component.literal((String)key)};
            }
            return new Component[]{Component.translatable((String)formatKey)};
        }
        return null;
    }
}

