/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.DynamicSubmodelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEMultiblockRenderer;
import blusunrize.immersiveengineering.client.utils.BatchingRenderTypeBuffer;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingMachineLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.bottling_machine.BottlingProcess;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BottlingMachineRenderer
extends IEMultiblockRenderer<BottlingMachineLogic.State> {
    public static final String NAME = "bottling_machine_dynamic";
    public static DynamicModel DYNAMIC;

    @Override
    public void render(IMultiblockContext<BottlingMachineLogic.State> ctx, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        MultiblockOrientation orientation = ctx.getLevel().getOrientation();
        BottlingMachineLogic.State state = ctx.getState();
        Direction facing = orientation.front();
        float pixelHeight = 0.0625f;
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.5, 0.5);
        MultiBufferSource originalBuffer = bufferIn;
        bufferIn = BERenderUtils.mirror(orientation, matrixStack, bufferIn);
        record ItemDisplay(float itemFill, Vector3f translation, BottlingProcess process) {
        }
        ArrayList<ItemDisplay> itemDisplays = new ArrayList<ItemDisplay>();
        float lift = 0.0f;
        Level level = ctx.getLevel().getRawLevel();
        VertexConsumer solidBuilder = bufferIn.getBuffer(RenderType.solid());
        for (int i = 0; i < state.processor.getQueueSize(); ++i) {
            float itemX;
            BottlingProcess process = (BottlingProcess)state.processor.getQueue().get(i);
            if (process == null) continue;
            float processMaxTicks = process.getMaxTicks(level);
            float transportTime = BottlingMachineLogic.getTransportTime(processMaxTicks);
            float liftTime = BottlingMachineLogic.getLiftTime(processMaxTicks);
            float fProcess = process.processTick;
            float itemY = 0.0f;
            float itemFill = 0.0f;
            if (fProcess < transportTime) {
                itemX = 0.5f * fProcess / transportTime;
            } else if (fProcess < processMaxTicks - transportTime) {
                itemX = 0.5f;
                if (fProcess < transportTime + liftTime) {
                    lift = (fProcess - transportTime) / liftTime;
                } else if (fProcess < processMaxTicks - (transportTime + liftTime)) {
                    lift = 1.0f;
                    itemFill = (fProcess - (transportTime + liftTime)) / (processMaxTicks - 2.0f * (transportTime + liftTime));
                } else {
                    lift = 1.0f - (fProcess - (processMaxTicks - transportTime - liftTime)) / liftTime;
                    itemFill = 1.0f;
                }
                lift *= 0.125f;
                if (lift > 0.0625f) {
                    itemY += lift - 0.0625f;
                }
            } else {
                itemX = 0.5f + 0.5f * (fProcess - (processMaxTicks - transportTime)) / transportTime;
                itemFill = 1.0f;
            }
            itemDisplays.add(new ItemDisplay(itemFill, new Vector3f((itemX - 0.5f) * 2.5f, itemY - 0.15625f, 1.0f), process));
        }
        matrixStack.pushPose();
        matrixStack.translate(0.0f, lift, 0.0f);
        BottlingMachineRenderer.renderModelPart(matrixStack, solidBuilder, facing, combinedLightIn, combinedOverlayIn, "lift");
        matrixStack.translate(0.0f, -lift, 0.0f);
        matrixStack.popPose();
        float dir = facing == Direction.SOUTH ? (float)Math.PI : (facing == Direction.NORTH ? 0.0f : (facing == Direction.EAST ? -1.5707964f : 1.5707964f));
        matrixStack.mulPose(new Quaternionf().rotateY(dir));
        FluidStack fs = state.tank.getFluid();
        if (!fs.isEmpty()) {
            float tankWidth = 7.0f;
            matrixStack.pushPose();
            float fluidLevel = (float)fs.getAmount() / (float)state.tank.getCapacity();
            matrixStack.translate(-0.21875, 0.376, 1.21875);
            matrixStack.scale(0.0625f, 0.0625f, 0.0625f);
            matrixStack.translate(3.5f, 0.0f, -3.5f);
            float h = fluidLevel * 9.0f;
            VertexConsumer builder = originalBuffer.getBuffer(RenderType.translucent());
            for (int i = 0; i < 4; ++i) {
                matrixStack.pushPose();
                matrixStack.translate(0.0f, 0.0f, -3.5f);
                GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, 0.0f, 7.0f, h);
                matrixStack.popPose();
                matrixStack.mulPose(new Quaternionf().rotateY(1.5707964f));
            }
            matrixStack.mulPose(new Quaternionf().rotateX(-1.5707964f));
            GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.mulPose(new Quaternionf().rotateX((float)Math.PI));
            matrixStack.translate(0.0f, 0.0f, -h);
            GuiHelper.drawRepeatedFluidSprite(builder, matrixStack, fs, -3.5f, -3.5f, 7.0f, 7.0f);
            matrixStack.popPose();
        }
        for (ItemDisplay item : itemDisplays) {
            List<ItemStack> display = item.process.getDisplayItem(level);
            matrixStack.pushPose();
            matrixStack.translate(item.translation.x(), item.translation.y(), item.translation.z());
            matrixStack.scale(0.4375f, 0.4375f, 0.4375f);
            if (!ClientUtils.mc().getMainRenderTarget().isStencilEnabled()) {
                for (ItemStack displayS : display) {
                    ClientUtils.mc().getItemRenderer().renderStatic(displayS, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, level, 0);
                }
            } else {
                float h0 = -0.5f;
                float h1 = h0 + item.itemFill;
                for (ItemStack inputS : item.process.inputItems) {
                    this.renderItemPart(bufferIn, matrixStack, inputS, h0, h1, combinedLightIn, combinedOverlayIn, 0, level);
                }
                for (ItemStack displayS : display) {
                    this.renderItemPart(bufferIn, matrixStack, displayS, h0, h1, combinedLightIn, combinedOverlayIn, 1, level);
                }
            }
            matrixStack.popPose();
        }
        matrixStack.popPose();
    }

    public static void renderModelPart(PoseStack matrixStack, VertexConsumer builder, Direction facing, int combinedLightIn, int combinedOverlayIn, String ... parts) {
        ModelData data = ModelDataUtils.single(DynamicSubmodelCallbacks.getProperty(), IEProperties.VisibilityList.show(parts));
        matrixStack.pushPose();
        matrixStack.translate(-0.5, -0.5, -0.5);
        List<BakedQuad> quads = DYNAMIC.getNullQuads(data);
        BottlingMachineRenderer.rotateForFacing(matrixStack, facing);
        RenderUtils.renderModelTESRFast(quads, builder, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.popPose();
    }

    private void renderItemPart(MultiBufferSource baseBuffer, PoseStack matrix, ItemStack item, float minY, float maxY, int combinedLightIn, int combinedOverlayIn, int ref, Level level) {
        PoseStack innerStack = new PoseStack();
        innerStack.last().pose().mul((Matrix4fc)matrix.last().pose());
        innerStack.last().normal().mul((Matrix3fc)matrix.last().normal());
        MultiBufferSource stencilWrapper = IERenderTypes.wrapWithStencil(baseBuffer, vertexBuilder -> {
            innerStack.pushPose();
            innerStack.mulPose(new Quaternionf().rotateY((90.0f - ClientUtils.mc().getEntityRenderDispatcher().camera.getYRot()) * ((float)Math.PI / 180)));
            RenderUtils.renderBox(vertexBuilder, innerStack, -0.5f, minY, -0.5f, 0.5f, maxY, 0.5f);
            innerStack.popPose();
        }, "min" + minY + "max" + maxY, ref);
        BatchingRenderTypeBuffer batchBuffer = new BatchingRenderTypeBuffer();
        ClientUtils.mc().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, matrix, (MultiBufferSource)batchBuffer, level, 0);
        batchBuffer.pipe(stencilWrapper);
    }
}

