/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiReactiveList;
import blusunrize.immersiveengineering.client.gui.info.EnergyInfoArea;
import blusunrize.immersiveengineering.client.gui.info.InfoArea;
import blusunrize.immersiveengineering.common.gui.ChunkLoaderMenu;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;

public class ChunkLoaderScreen
extends IEContainerScreen<ChunkLoaderMenu> {
    private static final ResourceLocation TEXTURE = ChunkLoaderScreen.makeTextureLocation("chunk_loader");

    public ChunkLoaderScreen(ChunkLoaderMenu container, Inventory inventoryPlayer, Component component) {
        super(container, inventoryPlayer, component, TEXTURE);
        this.imageHeight = 241;
    }

    @Override
    protected void init() {
        super.init();
        GuiReactiveList<ChunkLoaderMenu.NearbyBlockEntity> widget = new GuiReactiveList<ChunkLoaderMenu.NearbyBlockEntity>(this.leftPos + 6, this.topPos + 52, 100, 86, e -> {
            List<ChunkLoaderMenu.NearbyBlockEntity> list = ((ChunkLoaderMenu)this.menu).blockEntityList.get();
            BlockPos cystal = ((ChunkLoaderMenu)this.menu).crystalPos.get();
            if (e.selectedOption >= 0 && !list.isEmpty()) {
                list.get(e.selectedOption).pos().forEach(pos -> this.minecraft.level.addParticle((ParticleOptions)new VibrationParticleOption((PositionSource)new BlockPositionSource(pos), 60), (double)cystal.getX() + 0.5, (double)cystal.getY() + 0.5, (double)cystal.getZ() + 0.5, 0.0, 0.0, 0.0));
            }
        }, ((ChunkLoaderMenu)this.menu).blockEntityList, ChunkLoaderMenu.NearbyBlockEntity::getDisplayString).setPadding(0, 0, 6, 6).setTextStyling(9538949, 11381153, false);
        this.addRenderableWidget((GuiEventListener)widget);
    }

    @Override
    @Nonnull
    protected List<InfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new EnergyInfoArea(this.leftPos + 157, this.topPos + 96, ((ChunkLoaderMenu)this.menu).energy), (Object)new RefreshInfoArea(this.leftPos + 141, this.topPos + 94, ((ChunkLoaderMenu)this.menu).refreshTimer));
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        Slot s = (Slot)((ChunkLoaderMenu)this.menu).slots.get(0);
        if (!s.hasItem() && mouseX > this.leftPos + s.x && mouseX < this.leftPos + s.x + 16 && mouseY > this.topPos + s.y && mouseY < this.topPos + s.y + 16) {
            addLine.accept(Items.PAPER.getDescription());
        }
    }

    private static class RefreshInfoArea
    extends InfoArea {
        private final Supplier<Integer> refreshTimer;

        public RefreshInfoArea(int xMin, int yMin, Supplier<Integer> refreshTimer) {
            super(new Rect2i(xMin, yMin, 2, 16));
            this.refreshTimer = refreshTimer;
        }

        @Override
        protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
        }

        @Override
        public void draw(GuiGraphics graphics) {
            int height = this.area.getHeight();
            int stored = (int)((float)height * ((float)this.refreshTimer.get().intValue() / 1200.0f));
            graphics.blit(TEXTURE, this.area.getX(), this.area.getY() + (height - stored), 176, 75 + (height - stored), this.area.getWidth(), stored);
        }
    }
}

