/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.fx.FractalParticle;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.RenderUtils;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=EventBusSubscriber.Bus.GAME)
public class LevelStageRenders {
    public static final Map<Connection, Pair<Collection<BlockPos>, MutableInt>> FAILED_CONNECTIONS = new HashMap<Connection, Pair<Collection<BlockPos>, MutableInt>>();
    private static final boolean ENABLE_VEIN_DEBUG = false;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && !FractalParticle.PARTICLE_FRACTAL_DEQUE.isEmpty()) {
            LevelStageRenders.renderFractalParticles(event);
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            LevelStageRenders.renderMineralVeinDebug(event);
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            LevelStageRenders.renderFailedConnections(event);
        }
    }

    private static void renderFractalParticles(RenderLevelStageEvent event) {
        float partial = event.getPartialTick().getGameTimeDeltaTicks();
        Pair<PoseStack, MultiBufferSource.BufferSource> context = LevelStageRenders.prepare(event);
        ArrayList<Pair> renders = new ArrayList<Pair>();
        for (FractalParticle p : FractalParticle.PARTICLE_FRACTAL_DEQUE) {
            for (Pair<RenderType, Consumer<VertexConsumer>> r : p.render(partial, (PoseStack)context.getFirst())) {
                boolean added = false;
                for (Pair e : renders) {
                    if (!((RenderType)e.getFirst()).equals(r.getFirst())) continue;
                    ((List)e.getSecond()).add((Consumer)r.getSecond());
                    added = true;
                    break;
                }
                if (added) continue;
                renders.add(Pair.of((Object)((RenderType)r.getFirst()), new ArrayList<Consumer>(List.of((Consumer)r.getSecond()))));
            }
        }
        for (Pair entry : renders) {
            VertexConsumer bb = ((MultiBufferSource.BufferSource)context.getSecond()).getBuffer((RenderType)entry.getFirst());
            for (Consumer render : (List)entry.getSecond()) {
                render.accept(bb);
            }
        }
        LevelStageRenders.finish(context);
        FractalParticle.PARTICLE_FRACTAL_DEQUE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderMineralVeinDebug(RenderLevelStageEvent event) {
        Multimap<ResourceKey<Level>, MineralVein> minerals;
        boolean show = false;
        if (!show) {
            return;
        }
        show = Minecraft.getInstance().options.keyShift.isDefault() ? Screen.hasControlDown() : Screen.hasShiftDown();
        if (!show) {
            return;
        }
        Pair<PoseStack, MultiBufferSource.BufferSource> context = LevelStageRenders.prepare(event);
        PoseStack transform = (PoseStack)context.getFirst();
        ResourceKey dimension = ClientUtils.mc().player.getCommandSenderWorld().dimension();
        ArrayList<ResourceLocation> keyList = new ArrayList<ResourceLocation>(MineralMix.RECIPES.getRecipeNames((Level)ClientUtils.mc().level));
        keyList.sort(Comparator.comparing(ResourceLocation::toString));
        BlockPos feetPos = ClientUtils.mc().player.blockPosition();
        ColumnPos playerCol = new ColumnPos(feetPos.getX(), feetPos.getZ());
        long maxDistance = (long)((Integer)ClientUtils.mc().options.renderDistance().get()).intValue() * 24L;
        long maxDistanceSq = maxDistance * maxDistance;
        int minHeight = ClientUtils.mc().level.getMinBuildHeight();
        int maxHeight = ClientUtils.mc().level.getMaxBuildHeight();
        Multimap<ResourceKey<Level>, MineralVein> multimap = minerals = ExcavatorHandler.getMineralVeinList();
        synchronized (minerals) {
            for (MineralVein vein : minerals.get((Object)dimension)) {
                int p;
                long zDiff;
                ColumnPos pos;
                long xDiff;
                long distToPlayerSq;
                MineralMix mineral = vein.getMineral((Level)ClientUtils.mc().level);
                if (mineral == null || (distToPlayerSq = (xDiff = (long)((pos = vein.getPos()).x() - playerCol.x())) * xDiff + (zDiff = (long)(pos.z() - playerCol.z())) * zDiff) > maxDistanceSq) continue;
                int iC = keyList.indexOf(vein.getMineralName());
                DyeColor color = DyeColor.values()[iC % 16];
                Vector4f rgb = Utils.vec4fFromDye(color);
                transform.pushPose();
                transform.translate((float)pos.x(), 0.0f, (float)pos.z());
                VertexConsumer bufferBuilder = ((MultiBufferSource.BufferSource)context.getSecond()).getBuffer(IERenderTypes.CHUNK_MARKER);
                Matrix4f mat = transform.last().pose();
                bufferBuilder.addVertex(mat, 0.0f, (float)minHeight, 0.0f).setColor(rgb.x, rgb.y, rgb.z, 0.75f).setNormal(transform.last(), 0.0f, 1.0f, 0.0f);
                bufferBuilder.addVertex(mat, 0.0f, (float)maxHeight, 0.0f).setColor(rgb.x, rgb.y, rgb.z, 0.75f).setNormal(transform.last(), 0.0f, 1.0f, 0.0f);
                int radius = vein.getRadius();
                ArrayList<Vector3f> positions = new ArrayList<Vector3f>();
                for (p = 0; p < 12; ++p) {
                    float angle = 30.0f * (float)p;
                    double x1 = (double)radius * Math.cos((double)angle * Math.PI / 180.0);
                    double z1 = (double)radius * Math.sin((double)angle * Math.PI / 180.0);
                    positions.add(new Vector3f((float)x1, (float)(Minecraft.getInstance().player.position().y + 10.0), (float)z1));
                }
                for (p = 0; p < 12; ++p) {
                    Vector3f pointA = (Vector3f)positions.get(p);
                    Vector3f pointB = (Vector3f)positions.get((p + 1) % positions.size());
                    Vector3f diff = new Vector3f((Vector3fc)pointB);
                    diff.sub((Vector3fc)pointA);
                    diff.normalize();
                    for (Vector3f point : List.of(pointA, pointB)) {
                        bufferBuilder.addVertex(mat, point.x(), point.y(), point.z()).setColor(rgb.x, rgb.y, rgb.z, 0.75f).setNormal(transform.last(), diff.x(), diff.y(), diff.z());
                    }
                }
                transform.popPose();
            }
            // ** MonitorExit[var15_13] (shouldn't be in output)
            LevelStageRenders.finish(context);
            return;
        }
    }

    private static void renderFailedConnections(RenderLevelStageEvent event) {
        Pair<PoseStack, MultiBufferSource.BufferSource> context = LevelStageRenders.prepare(event);
        VertexConsumer builder = ((MultiBufferSource.BufferSource)context.getSecond()).getBuffer(IERenderTypes.CHUNK_MARKER);
        PoseStack transform = (PoseStack)context.getFirst();
        for (Map.Entry<Connection, Pair<Collection<BlockPos>, MutableInt>> entry : FAILED_CONNECTIONS.entrySet()) {
            Connection conn = entry.getKey();
            transform.pushPose();
            transform.translate((float)conn.getEndA().getX(), (float)conn.getEndA().getY(), (float)conn.getEndA().getZ());
            Matrix4f mat = transform.last().pose();
            int time = ((MutableInt)entry.getValue().getSecond()).intValue();
            float alpha = (float)Math.min((2.0 + Math.sin((double)time * Math.PI / 40.0)) / 3.0, (double)((float)time / 20.0f));
            Vec3 prev = conn.getPoint(0.0, conn.getEndA());
            for (int i = 0; i < 16; ++i) {
                Vec3 next = conn.getCatenaryData().getRenderPoint(i + 1);
                Vec3 diff = next.subtract(prev).normalize();
                builder.addVertex(mat, (float)prev.x, (float)prev.y, (float)prev.z).setColor(1.0f, 0.0f, 0.0f, alpha).setNormal(transform.last(), (float)diff.x, (float)diff.y, (float)diff.z);
                alpha = (float)Math.min((2.0 + Math.sin((double)(time + (i + 1) * 8) * Math.PI / 40.0)) / 3.0, (double)((float)time / 20.0f));
                builder.addVertex(mat, (float)next.x, (float)next.y, (float)next.z).setColor(1.0f, 0.0f, 0.0f, alpha).setNormal(transform.last(), (float)diff.x, (float)diff.y, (float)diff.z);
                prev = next;
            }
            transform.popPose();
        }
        LevelStageRenders.renderObstructingBlocks(context);
        LevelStageRenders.finish(context);
    }

    private static void renderObstructingBlocks(Pair<PoseStack, MultiBufferSource.BufferSource> context) {
        PoseStack transform = (PoseStack)context.getFirst();
        TransformingVertexBuilder builder = new TransformingVertexBuilder((MultiBufferSource)context.getSecond(), IERenderTypes.TRANSLUCENT_POSITION_COLOR);
        builder.defaultColor(255.0f, 0.0f, 0.0f, 128.0f);
        for (Map.Entry<Connection, Pair<Collection<BlockPos>, MutableInt>> entry : FAILED_CONNECTIONS.entrySet()) {
            for (BlockPos obstruction : (Collection)entry.getValue().getFirst()) {
                transform.pushPose();
                transform.translate((float)obstruction.getX(), (float)obstruction.getY(), (float)obstruction.getZ());
                float eps = 0.001f;
                RenderUtils.renderBox((VertexConsumer)builder, transform, -0.001f, -0.001f, -0.001f, 1.001f, 1.001f, 1.001f);
                transform.popPose();
            }
        }
        builder.unsetDefaultColor();
    }

    private static Pair<PoseStack, MultiBufferSource.BufferSource> prepare(RenderLevelStageEvent event) {
        PoseStack transform = event.getPoseStack();
        transform.pushPose();
        Vec3 cameraPos = event.getCamera().getPosition();
        transform.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        MultiBufferSource.BufferSource buffers = ClientUtils.mc().renderBuffers().bufferSource();
        return Pair.of((Object)transform, (Object)buffers);
    }

    private static void finish(Pair<PoseStack, MultiBufferSource.BufferSource> context) {
        ((MultiBufferSource.BufferSource)context.getSecond()).endBatch();
        ((PoseStack)context.getFirst()).popPose();
    }
}

