/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;

public class SafeChunkUtils {
    public static LevelChunk getSafeChunk(LevelAccessor w, BlockPos pos) {
        ChunkSource provider = w.getChunkSource();
        ChunkPos chunkPos = new ChunkPos(pos);
        return provider.getChunkNow(chunkPos.x, chunkPos.z);
    }

    public static boolean isChunkSafe(LevelAccessor w, BlockPos pos) {
        return SafeChunkUtils.getSafeChunk(w, pos) != null;
    }

    public static BlockEntity getSafeBE(LevelAccessor w, BlockPos pos) {
        LevelChunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return null;
        }
        return c.getBlockEntity(pos);
    }

    @Nonnull
    public static BlockState getBlockState(LevelAccessor w, BlockPos pos) {
        LevelChunk c = SafeChunkUtils.getSafeChunk(w, pos);
        if (c == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return c.getBlockState(pos);
    }
}

