/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.neoforge.common.block;

import cjminecraft.doubleslabs.common.block.MixedDoubleSlabBlock;
import cjminecraft.doubleslabs.common.hooks.MixedDoubleSlabBlockHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class NeoForgeMixedDoubleSlabBlock
extends MixedDoubleSlabBlock {
    public NeoForgeMixedDoubleSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean usePlayerDestroy = MixedDoubleSlabBlockHooks.removeBlock(state, level, pos, player, willHarvest);
        return usePlayerDestroy || super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return MixedDoubleSlabBlockHooks.getCloneItemStack(level, pos, target);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return MixedDoubleSlabBlockHooks.getSoundType((BlockGetter)level, pos, entity).orElseGet(() -> super.getSoundType(state, level, pos, entity));
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return MixedDoubleSlabBlockHooks.getParticleForTopSlab((BlockGetter)level, pos).map(particle -> {
            level.sendParticles((ParticleOptions)particle, entity.getX(), entity.getY(), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
            return true;
        }).orElse(false);
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return MixedDoubleSlabBlockHooks.getParticleForTopSlab((BlockGetter)level, pos).map(particle -> {
            level.addParticle((ParticleOptions)particle, entity.getX(), entity.getY(), entity.getZ(), 0.0, 0.0, 0.0);
            return true;
        }).orElse(false);
    }
}

