/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.neoforge.client.model;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.client.ClientInternal;
import cjminecraft.doubleslabs.client.model.DynamicSlabBakedModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NeoForgeDynamicSlabBakedModel
extends DynamicSlabBakedModel {
    public static final ModelProperty<IDynamicSlabStateContainer> DYNAMIC_SLAB_STATE_CONTAINER = new ModelProperty();

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random) {
        return Collections.emptyList();
    }

    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        BakedModel model = data.has(DYNAMIC_SLAB_STATE_CONTAINER) ? Objects.requireNonNull((IDynamicSlabStateContainer)data.get(DYNAMIC_SLAB_STATE_CONTAINER)).callOnBlockState(Half.POSITIVE, state -> Minecraft.getInstance().getBlockRenderer().getBlockModel(state), ClientInternal::getFallbackModel) : ClientInternal.getFallbackModel();
        return model.getParticleIcon(ModelData.EMPTY);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        if (data.has(DYNAMIC_SLAB_STATE_CONTAINER)) {
            IDynamicSlabStateContainer stateContainer = Objects.requireNonNull((IDynamicSlabStateContainer)data.get(DYNAMIC_SLAB_STATE_CONTAINER));
            BlockRenderDispatcher renderDispatcher = Minecraft.getInstance().getBlockRenderer();
            HashSet renderTypes = new HashSet();
            stateContainer.runOnBlockStates(slabState -> {
                BakedModel model = renderDispatcher.getBlockModel(slabState);
                renderTypes.addAll(model.getRenderTypes(slabState, rand, data).asList());
            });
            return ChunkRenderTypeSet.of(renderTypes);
        }
        return ChunkRenderTypeSet.all();
    }
}

