/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.hooks;

import cjminecraft.doubleslabs.api.state.Half;
import cjminecraft.doubleslabs.api.state.IDynamicSlabStateContainer;
import cjminecraft.doubleslabs.common.block.entity.DynamicSlabBlockEntity;
import cjminecraft.doubleslabs.common.hooks.DynamicSlabBlockHooks;
import cjminecraft.doubleslabs.common.init.DSBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MixedDoubleSlabBlockHooks
extends DynamicSlabBlockHooks {
    @Nullable
    protected static Half getHalfFromHitResult(HitResult hitResult, BlockPos slabPos) {
        if (hitResult.getType() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos hitPos = ((BlockHitResult)hitResult).getBlockPos();
        if (!slabPos.equals((Object)hitPos)) {
            return null;
        }
        Vec3 hitLocation = hitResult.getLocation();
        double hitOffset = hitLocation.y - (double)slabPos.getY();
        return hitOffset > 0.5 ? Half.POSITIVE : Half.NEGATIVE;
    }

    @Nullable
    protected static Half getHalfFromLookingAtBlock(Player player, BlockPos slabPos) {
        HitResult hitResult = player.pick(player.blockInteractionRange(), 0.0f, false);
        return MixedDoubleSlabBlockHooks.getHalfFromHitResult(hitResult, slabPos);
    }

    private static Half getHalfFromPlayerUsingCollision(Player player, VoxelShape collisionShape, BlockPos slabPos) {
        Vec3 clipStart = player.getEyePosition();
        Vec3 clipEnd = player.getEyePosition().add(player.getLookAngle().scale(player.blockInteractionRange()));
        BlockHitResult hitResult = Objects.requireNonNull(collisionShape.clip(clipStart, clipEnd, slabPos));
        return Objects.requireNonNull(MixedDoubleSlabBlockHooks.getHalfFromHitResult((HitResult)hitResult, slabPos));
    }

    protected static void runOnLookingAtBlockState(BlockGetter blockGetter, BlockPos pos, HitResult hitResult, Consumer<BlockState> consumer) {
        Half slabHalf = MixedDoubleSlabBlockHooks.getHalfFromHitResult(hitResult, pos);
        if (slabHalf == null) {
            return;
        }
        MixedDoubleSlabBlockHooks.runOnBlockState(blockGetter, pos, slabHalf, consumer);
    }

    protected static <T> Optional<T> callOnLookingAtBlockState(BlockGetter blockGetter, BlockPos pos, HitResult hitResult, Function<BlockState, T> function) {
        Half slabHalf = MixedDoubleSlabBlockHooks.getHalfFromHitResult(hitResult, pos);
        if (slabHalf == null) {
            return Optional.empty();
        }
        return MixedDoubleSlabBlockHooks.callOnBlockState(blockGetter, pos, slabHalf, function);
    }

    protected static <T> Optional<T> callOnLookingAtBlockState(BlockGetter blockGetter, BlockPos pos, Player player, Function<BlockState, T> function) {
        Half slabHalf = MixedDoubleSlabBlockHooks.getHalfFromLookingAtBlock(player, pos);
        if (slabHalf == null) {
            return Optional.empty();
        }
        return MixedDoubleSlabBlockHooks.callOnBlockState(blockGetter, pos, slabHalf, function);
    }

    public static Optional<Float> getDestroyProgress(Player player, BlockGetter blockGetter, BlockPos pos) {
        return MixedDoubleSlabBlockHooks.callOnLookingAtBlockState(blockGetter, pos, player, (BlockState state) -> Float.valueOf(state.getDestroyProgress(player, blockGetter, pos))).or(() -> MixedDoubleSlabBlockHooks.minFromBlockState(blockGetter, pos, state -> Float.valueOf(state.getDestroyProgress(player, blockGetter, pos))));
    }

    public static boolean removeBlock(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        if (player.isCreative() && player.isCrouching()) {
            MixedDoubleSlabBlockHooks.playerDestroy(player, level, pos, state, level.getBlockEntity(pos), player.getMainHandItem());
            return true;
        }
        return false;
    }

    public static void playerDestroy(Player player, Level level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        Half halfToRemove = MixedDoubleSlabBlockHooks.getHalfFromPlayerUsingCollision(player, state.getCollisionShape((BlockGetter)level, pos), pos);
        if (!(blockEntity instanceof IDynamicSlabStateContainer)) {
            player.causeFoodExhaustion(0.005f);
            Block.dropResources((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)tool);
        } else {
            IDynamicSlabStateContainer container = (IDynamicSlabStateContainer)blockEntity;
            Half halfToKeep = halfToRemove.getOpposite();
            MixedDoubleSlabBlockHooks.destroyHalf(container, player, level, pos, tool, halfToRemove, slabContainer -> Block.dropResources((BlockState)slabContainer.getBlockState(), (Level)level, (BlockPos)pos, (BlockEntity)slabContainer.getBlockEntity(), (Entity)player, (ItemStack)tool));
            container.runOnStateContainer(halfToKeep, slabContainer -> {
                if (!slabContainer.hasBlockState()) {
                    return;
                }
                BlockState slabState = slabContainer.getBlockState();
                level.setBlock(pos, slabState, level.isClientSide() ? 11 : 3);
                if (slabContainer.hasBlockEntity()) {
                    level.setBlockEntity(Objects.requireNonNull(slabContainer.getBlockEntity()));
                } else {
                    level.removeBlockEntity(pos);
                }
            });
        }
    }

    public static ItemStack getCloneItemStack(LevelReader level, BlockPos pos, HitResult hitResult) {
        return MixedDoubleSlabBlockHooks.callOnLookingAtBlockState((BlockGetter)level, pos, hitResult, (BlockState state) -> state.getBlock().getCloneItemStack(level, pos, state)).orElse(ItemStack.EMPTY);
    }

    public static Optional<SoundType> getSoundType(BlockGetter blockGetter, BlockPos pos, @Nullable Entity entity) {
        Player player;
        Optional<SoundType> destroyBlockSound;
        if (entity instanceof Player && (destroyBlockSound = MixedDoubleSlabBlockHooks.callOnLookingAtBlockState(blockGetter, pos, player = (Player)entity, BlockBehaviour.BlockStateBase::getSoundType)).isPresent()) {
            return destroyBlockSound;
        }
        if (entity != null) {
            return MixedDoubleSlabBlockHooks.callOnBlockState(blockGetter, pos, Half.POSITIVE, BlockBehaviour.BlockStateBase::getSoundType);
        }
        return Optional.empty();
    }

    public static Optional<BlockParticleOption> getParticleForTopSlab(BlockGetter blockGetter, BlockPos pos) {
        return MixedDoubleSlabBlockHooks.callOnBlockState(blockGetter, pos, Half.POSITIVE, state -> new BlockParticleOption(ParticleTypes.BLOCK, state));
    }

    public static boolean propagatesSkylightDown(BlockGetter blockGetter, BlockPos pos) {
        return MixedDoubleSlabBlockHooks.requireBothStates(blockGetter, pos, state -> state.propagatesSkylightDown(blockGetter, pos));
    }

    public static boolean fallOn(Level level, BlockPos pos, Entity entity, float fallDistance) {
        return MixedDoubleSlabBlockHooks.callOnBlockState((BlockGetter)level, pos, Half.POSITIVE, state -> {
            state.getBlock().fallOn(level, state, pos, entity, fallDistance);
            return true;
        }).orElse(false);
    }

    public static boolean updateEntityAfterFallOn(BlockGetter blockGetter, Entity entity) {
        BlockPos pos = entity.getOnPos();
        if (!blockGetter.getBlockState(pos).is(DSBlocks.MIXED_SLABS)) {
            return false;
        }
        return MixedDoubleSlabBlockHooks.callOnBlockState(blockGetter, pos, Half.POSITIVE, state -> {
            state.getBlock().updateEntityAfterFallOn(blockGetter, entity);
            return true;
        }).orElse(false);
    }

    public static boolean stepOn(Level level, BlockPos pos, Entity entity) {
        return MixedDoubleSlabBlockHooks.callOnBlockState((BlockGetter)level, pos, Half.POSITIVE, state -> {
            state.getBlock().stepOn(level, pos, state, entity);
            return true;
        }).orElse(false);
    }

    public static Optional<VoxelShape> getCollisionShape(BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return MixedDoubleSlabBlockHooks.reduceOnBlockStates(blockGetter, pos, state -> state.getCollisionShape(blockGetter, pos, context), Shapes::or);
    }

    public static List<ItemStack> getDrops(LootParams.Builder params) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        BlockEntity blockEntity = (BlockEntity)params.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof DynamicSlabBlockEntity) {
            DynamicSlabBlockEntity dynamicSlab = (DynamicSlabBlockEntity)blockEntity;
            dynamicSlab.runOnStateContainers(container -> {
                if (!container.hasBlockState()) {
                    return;
                }
                BlockState slabState = container.getBlockState();
                LootParams.Builder slabParams = params.withParameter(LootContextParams.BLOCK_STATE, (Object)slabState);
                if (container.hasBlockEntity()) {
                    slabParams = slabParams.withParameter(LootContextParams.BLOCK_ENTITY, (Object)Objects.requireNonNull(container.getBlockEntity()));
                }
                drops.addAll(slabState.getDrops(slabParams));
            });
        }
        return drops;
    }
}

