/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.crafting;

import cjminecraft.doubleslabs.common.Internal;
import cjminecraft.doubleslabs.common.init.DSItems;
import cjminecraft.doubleslabs.common.init.DSRecipes;
import cjminecraft.doubleslabs.common.item.VerticalSlabItem;
import cjminecraft.doubleslabs.common.item.component.VerticalSlabContent;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VerticalSlabConversionRecipe
extends CustomRecipe {
    private static final Ingredient VERTICAL_SLAB = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)DSItems.VERTICAL_SLAB.get()});

    public VerticalSlabConversionRecipe(CraftingBookCategory category) {
        super(category);
    }

    private Optional<ItemStack> getMatch(CraftingInput craftingInput) {
        if (craftingInput.ingredientCount() != 1) {
            return Optional.empty();
        }
        ItemStack stack = craftingInput.getItem(0);
        return Internal.getSlabHelper().isHorizontalSlab(stack) || VERTICAL_SLAB.test(stack) ? Optional.of(stack) : Optional.empty();
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return this.getMatch(craftingInput).isPresent();
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack stack = craftingInput.getItem(0);
        if (VERTICAL_SLAB.test(stack)) {
            return Objects.requireNonNull((VerticalSlabContent)stack.get(DSItems.VERTICAL_SLAB_CONTENT.get())).getItem().copy();
        }
        return VerticalSlabItem.of(stack);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)DSRecipes.VERTICAL_SLAB_CONVERSION_SERIALIZER.get();
    }
}

