/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.common.block;

import cjminecraft.doubleslabs.api.state.VerticalSlabType;
import cjminecraft.doubleslabs.common.block.DynamicSlabBlock;
import cjminecraft.doubleslabs.common.hooks.VerticalSlabBlockHooks;
import cjminecraft.doubleslabs.common.init.DSItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends DynamicSlabBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.create((String)"type", VerticalSlabType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape X_POSITIVE_AABB = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape X_NEGATIVE_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    public static final VoxelShape Z_POSITIVE_AABB = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape Z_NEGATIVE_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);

    public VerticalSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TYPE, (Comparable)((Object)VerticalSlabType.NEGATIVE))).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, TYPE, WATERLOGGED});
    }

    public Item asItem() {
        return (Item)DSItems.VERTICAL_SLAB.get();
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        VerticalSlabType slabType = (VerticalSlabType)((Object)state.getValue(TYPE));
        return switch (slabType) {
            default -> throw new MatchException(null, null);
            case VerticalSlabType.POSITIVE -> {
                if (axis == Direction.Axis.X) {
                    yield X_POSITIVE_AABB;
                }
                yield Z_POSITIVE_AABB;
            }
            case VerticalSlabType.NEGATIVE -> {
                if (axis == Direction.Axis.X) {
                    yield X_NEGATIVE_AABB;
                }
                yield Z_NEGATIVE_AABB;
            }
            case VerticalSlabType.DOUBLE -> Shapes.block();
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        double positionAlongAxis;
        BlockPos clickedPos = context.getClickedPos();
        BlockState clickedState = context.getLevel().getBlockState(clickedPos);
        if (clickedState.is((Block)this)) {
            return (BlockState)((BlockState)clickedState.setValue(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE);
        }
        FluidState fluidState = context.getLevel().getFluidState(clickedPos);
        boolean waterlogged = fluidState.getType() == Fluids.WATER;
        Direction clickedFace = context.getClickedFace();
        Vec3 clickLocation = context.getClickLocation();
        Vec3 locationRelativeToCenter = clickLocation.subtract(clickedPos.getCenter());
        if (clickedFace.getAxis().isVertical()) {
            double angle = Math.toDegrees(Math.atan2(locationRelativeToCenter.x, locationRelativeToCenter.z));
            Direction direction = Direction.fromYRot((double)(-angle));
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)direction.getAxis())).setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromAxisDirection(direction.getAxisDirection())))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        double d = positionAlongAxis = clickedFace.getAxis() == Direction.Axis.X ? locationRelativeToCenter.z : locationRelativeToCenter.x;
        if (-0.25 < positionAlongAxis && positionAlongAxis < 0.25) {
            return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)clickedFace.getAxis())).setValue(TYPE, (Comparable)((Object)VerticalSlabType.fromAxisDirection(clickedFace.getAxisDirection().opposite())))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)(clickedFace.getAxis() == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X))).setValue(TYPE, (Comparable)((Object)(positionAlongAxis < 0.0 ? VerticalSlabType.NEGATIVE : VerticalSlabType.POSITIVE)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.placeLiquid(level, pos, state, fluidState);
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.getValue(TYPE) != VerticalSlabType.DOUBLE && super.canPlaceLiquid(player, level, pos, state, fluid);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return pathComputationType == PathComputationType.WATER && state.getFluidState().is(FluidTags.WATER);
    }

    protected boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack heldItem = context.getItemInHand();
        VerticalSlabType slabType = (VerticalSlabType)((Object)state.getValue(TYPE));
        if (slabType == VerticalSlabType.DOUBLE || !heldItem.is(this.asItem())) {
            return false;
        }
        if (!context.replacingClickedOnBlock()) {
            return true;
        }
        Direction.Axis axis = (Direction.Axis)state.getValue(AXIS);
        Direction slabFacingDirection = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)slabType.toAxisDirection());
        return slabFacingDirection == context.getClickedFace().getOpposite();
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        return VerticalSlabBlockHooks.getDrops(params);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return VerticalSlabBlockHooks.getDestroyProgress(player, level, state, pos).orElseGet(() -> Float.valueOf(super.getDestroyProgress(state, player, level, pos))).floatValue();
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        VerticalSlabBlockHooks.playerDestroy(player, level, pos, state, blockEntity, tool);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return VerticalSlabBlockHooks.propagateSkylightDown(level, pos);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!VerticalSlabBlockHooks.fallOn(level, state, pos, entity, fallDistance)) {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        if (!VerticalSlabBlockHooks.updateEntityAfterFallOn(level, entity)) {
            super.updateEntityAfterFallOn(level, entity);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!VerticalSlabBlockHooks.stepOn(level, state, pos, entity)) {
            super.stepOn(level, pos, state, entity);
        }
    }
}

