/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.client.model;

import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class PlatformIndependentModelBaker
implements ModelBaker {
    protected final ModelBakery bakery;
    protected final ModelManager manager;

    public PlatformIndependentModelBaker(ModelBakery bakery, ModelManager manager) {
        this.bakery = bakery;
        this.manager = manager;
    }

    public UnbakedModel getModel(ResourceLocation resourceLocation) {
        return this.bakery.getModel(resourceLocation);
    }

    @Nullable
    public BakedModel bake(ResourceLocation resourceLocation, ModelState modelState) {
        UnbakedModel model = this.getModel(resourceLocation);
        return model.bake((ModelBaker)this, this::getTextureSprite, modelState);
    }

    public TextureAtlasSprite getTextureSprite(Material material) {
        return this.manager.getAtlas(material.atlasLocation()).getSprite(material.texture());
    }
}

