/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.state;

import cjminecraft.doubleslabs.api.state.Half;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;

public enum VerticalSlabType implements StringRepresentable
{
    POSITIVE("positive"),
    NEGATIVE("negative"),
    DOUBLE("double");

    private final String name;

    private VerticalSlabType(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public Half getHalf() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Half.POSITIVE;
            case 1 -> Half.NEGATIVE;
            case 2 -> throw new IllegalStateException("Cannot get the half of a double slab type");
        };
    }

    public Direction.AxisDirection toAxisDirection() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Direction.AxisDirection.POSITIVE;
            case 1 -> Direction.AxisDirection.NEGATIVE;
            case 2 -> throw new IllegalStateException("Cannot get the axis direction of a double slab type");
        };
    }

    public static VerticalSlabType fromAxisDirection(Direction.AxisDirection axisDirection) {
        return switch (axisDirection) {
            default -> throw new MatchException(null, null);
            case Direction.AxisDirection.POSITIVE -> POSITIVE;
            case Direction.AxisDirection.NEGATIVE -> NEGATIVE;
        };
    }

    public static VerticalSlabType fromHalf(Half half) {
        return switch (half) {
            default -> throw new MatchException(null, null);
            case Half.POSITIVE -> POSITIVE;
            case Half.NEGATIVE -> NEGATIVE;
        };
    }

    public Direction getDirection(Half half, Direction.Axis axis) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (axis == Direction.Axis.X) {
                    yield Direction.EAST;
                }
                yield Direction.SOUTH;
            }
            case 1 -> {
                if (axis == Direction.Axis.X) {
                    yield Direction.WEST;
                }
                yield Direction.NORTH;
            }
            case 2 -> {
                switch (half) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case POSITIVE: {
                        if (axis == Direction.Axis.X) {
                            yield Direction.EAST;
                        }
                        yield Direction.SOUTH;
                    }
                    case NEGATIVE: 
                }
                yield axis == Direction.Axis.X ? Direction.WEST : Direction.NORTH;
            }
        };
    }

    public VerticalSlabType getOpposite() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NEGATIVE;
            case 1 -> POSITIVE;
            case 2 -> throw new IllegalStateException("Cannot get the opposite of a double slab type");
        };
    }
}

