/*
 * Decompiled with CFR 0.152.
 */
package cjminecraft.doubleslabs.api.state;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface ISlabStateContainer {
    default public void clear() {
        this.setBlockState(Blocks.AIR.defaultBlockState());
        this.setBlockEntity(null);
    }

    public BlockState getBlockState();

    public void setBlockState(BlockState var1);

    default public boolean hasBlockState() {
        return !this.getBlockState().isAir();
    }

    default public void runOnBlockState(Consumer<BlockState> consumer) {
        if (this.hasBlockState()) {
            consumer.accept(this.getBlockState());
        }
    }

    default public <T> T callOnBlockState(Function<BlockState, T> function, Supplier<T> orElse) {
        return this.hasBlockState() ? function.apply(this.getBlockState()) : orElse.get();
    }

    default public <T> Optional<T> callOnBlockState(Function<BlockState, T> function) {
        return this.hasBlockState() ? Optional.of(function.apply(this.getBlockState())) : Optional.empty();
    }

    @Nullable
    public BlockEntity getBlockEntity();

    public void setBlockEntity(@Nullable BlockEntity var1);

    default public boolean hasBlockEntity() {
        return this.getBlockEntity() != null;
    }

    default public void runOnBlockEntity(Consumer<BlockEntity> consumer) {
        if (this.hasBlockEntity()) {
            consumer.accept(this.getBlockEntity());
        }
    }

    default public <T> T callOnBlockEntity(Function<BlockEntity, T> function, Supplier<T> orElse) {
        return this.hasBlockEntity() ? function.apply(this.getBlockEntity()) : orElse.get();
    }

    default public <T> Optional<T> callOnBlockEntity(Function<BlockEntity, T> function) {
        return this.hasBlockEntity() ? Optional.of(function.apply(this.getBlockEntity())) : Optional.empty();
    }

    public BlockPos getBlockPos();

    @Nullable
    public Level getLevel();

    public void setLevel(@Nullable Level var1);

    default public boolean hasLevel() {
        return this.getLevel() != null;
    }

    default public CompoundTag serialize(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.runOnBlockState(state -> tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)state)));
        this.runOnBlockEntity(blockEntity -> tag.put("blockEntity", (Tag)blockEntity.saveWithId(registries)));
        return tag;
    }

    default public void deserialize(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("state")) {
            HolderLookup.RegistryLookup blockGetter = this.hasLevel() ? Objects.requireNonNull(this.getLevel()).holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
            this.setBlockState(NbtUtils.readBlockState((HolderGetter)blockGetter, (CompoundTag)tag.getCompound("state")));
        }
        if (tag.contains("blockEntity")) {
            this.setBlockEntity(BlockEntity.loadStatic((BlockPos)this.getBlockPos(), (BlockState)this.getBlockState(), (CompoundTag)tag.getCompound("blockEntity"), (HolderLookup.Provider)registries));
        }
    }
}

