/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.registry;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.util.BiomeEffects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeSpecialEffectsBuilder;
import net.neoforged.neoforge.common.world.ClimateSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public class LithostitchedNeoforgeBiomeModifiers {

    public record ReplaceEffectsBiomeModifier(HolderSet<Biome> biomes, BiomeEffects specialEffects) implements BiomeModifier
    {
        public static final MapCodec<ReplaceEffectsBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ReplaceEffectsBiomeModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsBiomeModifier::specialEffects)).apply((Applicative)builder, ReplaceEffectsBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder info) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().contains(biome)) {
                BiomeSpecialEffectsBuilder builder = info.getSpecialEffects();
                this.tryApply(BiomeEffects::fogColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).fogColor(arg_0));
                this.tryApply(BiomeEffects::waterColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).waterColor(arg_0));
                this.tryApply(BiomeEffects::waterFogColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).waterFogColor(arg_0));
                this.tryApply(BiomeEffects::skyColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).skyColor(arg_0));
                this.tryApply(BiomeEffects::foliageColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).foliageColorOverride(arg_0));
                this.tryApply(BiomeEffects::grassColor, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).grassColorOverride(arg_0));
                this.tryApply(BiomeEffects::grassColorModifier, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).grassColorModifier(arg_0));
                this.tryApply(BiomeEffects::ambientParticle, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientParticle(arg_0));
                this.tryApply(BiomeEffects::ambientSound, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientLoopSound(arg_0));
                this.tryApply(BiomeEffects::moodSound, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientMoodSound(arg_0));
                this.tryApply(BiomeEffects::additionsSound, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).ambientAdditionsSound(arg_0));
                this.tryApply(BiomeEffects::music, arg_0 -> ((BiomeSpecialEffectsBuilder)builder).backgroundMusic(arg_0));
            }
        }

        private <T> void tryApply(Function<BiomeEffects, Optional<T>> getter, Consumer<T> applier) {
            getter.apply(this.specialEffects).ifPresent(applier);
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }

    public record ReplaceClimateBiomeModifier(HolderSet<Biome> biomes, Biome.ClimateSettings climateSettings) implements BiomeModifier
    {
        public static final MapCodec<ReplaceClimateBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(ReplaceClimateBiomeModifier::biomes), (App)Biome.ClimateSettings.CODEC.fieldOf("climate").forGetter(ReplaceClimateBiomeModifier::climateSettings)).apply((Applicative)builder, ReplaceClimateBiomeModifier::new));

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.MODIFY && this.biomes().contains(biome)) {
                ClimateSettingsBuilder climateSettings = builder.getClimateSettings();
                climateSettings.setTemperature(this.climateSettings().temperature());
                climateSettings.setDownfall(this.climateSettings().downfall());
                climateSettings.setHasPrecipitation(this.climateSettings().hasPrecipitation());
                climateSettings.setTemperatureModifier(this.climateSettings().temperatureModifier());
            }
        }

        public MapCodec<? extends BiomeModifier> codec() {
            return CODEC;
        }
    }
}

