/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.mixin.common;

import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.AbstractBiomeModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ServerLifecycleHooks.class}, remap=false)
public class ServerLifecycleHooksMixin {
    @ModifyVariable(method={"runModifiers(Lnet/minecraft/server/MinecraftServer;)V"}, at=@At(value="STORE"), ordinal=0)
    private static List<BiomeModifier> lithostitched$injectBiomeModifers(List<BiomeModifier> biomeModifiers, MinecraftServer server) {
        ArrayList<BiomeModifier> allBiomeModifiers = new ArrayList<BiomeModifier>(biomeModifiers);
        Set<Map.Entry> lithostitchedBiomeModifiers = server.registryAccess().registryOrThrow(LithostitchedRegistryKeys.WORLDGEN_MODIFIER).entrySet().stream().filter(entry -> entry.getValue() instanceof AbstractBiomeModifier).collect(Collectors.toSet());
        lithostitchedBiomeModifiers.forEach(entry -> {
            AbstractBiomeModifier modifier = (AbstractBiomeModifier)entry.getValue();
            allBiomeModifiers.add(modifier.neoforgeBiomeModifier());
        });
        return allBiomeModifiers;
    }
}

