/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.attachment.PowerLevel;
import nl.requios.effortlessbuilding.network.message.PowerLevelPacket;

public class PowerLevelCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"powerlevel").requires(cs -> cs.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"query").executes(ctx -> {
            PowerLevelCommand.logPowerLevel((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).getPlayerOrException());
            return 0;
        })).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"target");
            PowerLevelCommand.logPowerLevel((CommandSourceStack)ctx.getSource(), (Player)player);
            return 0;
        })))).then(Commands.literal((String)"set").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3)).executes(ctx -> {
            PowerLevelCommand.setPowerLevel((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.getPlayer((CommandContext)ctx, (String)"target"), (Integer)ctx.getArgument("value", Integer.class));
            return 0;
        })))));
    }

    private static void logPowerLevel(CommandSourceStack source, Player player) {
        int powerLevel = AttachmentHandler.getPowerLevel(player);
        source.sendSuccess(() -> Component.translatable((String)"effortlessbuilding.commands.powerlevel", (Object[])new Object[]{player.getDisplayName(), powerLevel}), false);
    }

    private static void setPowerLevel(CommandSourceStack source, Player player, int powerLevel) throws CommandSyntaxException {
        PowerLevel powerCap = (PowerLevel)player.getData(EffortlessBuilding.POWER_LEVEL);
        powerCap.setPowerLevel(powerLevel);
        ((ServerPlayer)player).connection.send((CustomPacketPayload)new PowerLevelPacket(powerLevel));
        source.sendSuccess(() -> Component.translatable((String)"effortlessbuilding.commands.powerlevel.success", (Object[])new Object[]{player.getDisplayName(), powerLevel}), true);
    }
}

