/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.buildmode.ModeOptions;
import nl.requios.effortlessbuilding.network.message.IsQuickReplacingPacket;

@OnlyIn(value=Dist.CLIENT)
public class BuildSettings {
    private ReplaceMode replaceMode = ReplaceMode.ONLY_AIR;
    private boolean protectTileEntities = true;

    public boolean isQuickReplacing() {
        return this.getReplaceMode() != ReplaceMode.ONLY_AIR;
    }

    public void setReplaceMode(ReplaceMode replaceMode) {
        this.replaceMode = replaceMode;
        PacketDistributor.sendToServer((CustomPacketPayload)new IsQuickReplacingPacket(this.isQuickReplacing()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public ReplaceMode getReplaceMode() {
        if (!this.canReplaceBlocks()) {
            return ReplaceMode.ONLY_AIR;
        }
        return this.replaceMode;
    }

    public ModeOptions.ActionEnum getReplaceModeActionEnum() {
        return switch (this.getReplaceMode().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ModeOptions.ActionEnum.REPLACE_ONLY_AIR;
            case 1 -> ModeOptions.ActionEnum.REPLACE_BLOCKS_AND_AIR;
            case 2 -> ModeOptions.ActionEnum.REPLACE_ONLY_BLOCKS;
            case 3 -> ModeOptions.ActionEnum.REPLACE_FILTERED_BY_OFFHAND;
        };
    }

    public void toggleProtectTileEntities() {
        this.protectTileEntities = !this.protectTileEntities;
    }

    public boolean shouldReplaceAir() {
        return this.getReplaceMode() == ReplaceMode.ONLY_AIR || this.getReplaceMode() == ReplaceMode.BLOCKS_AND_AIR;
    }

    public boolean shouldReplaceBlocks() {
        return this.getReplaceMode() == ReplaceMode.ONLY_BLOCKS || this.getReplaceMode() == ReplaceMode.BLOCKS_AND_AIR;
    }

    public boolean shouldReplaceFiltered() {
        return this.getReplaceMode() == ReplaceMode.FILTERED_BY_OFFHAND;
    }

    public boolean shouldProtectTileEntities() {
        return this.protectTileEntities;
    }

    public boolean shouldOffsetStartPosition() {
        return this.getReplaceMode() != ReplaceMode.ONLY_AIR;
    }

    private boolean canReplaceBlocks() {
        return Minecraft.getInstance().player != null && AttachmentHandler.canReplaceBlocks((Player)Minecraft.getInstance().player);
    }

    public static enum ReplaceMode {
        ONLY_AIR,
        BLOCKS_AND_AIR,
        ONLY_BLOCKS,
        FILTERED_BY_OFFHAND;

    }
}

