/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nl.requios.effortlessbuilding.EffortlessBuilding;

public record TranslatedLogPacket(String prefix, String translationKey, String suffix, boolean actionBar) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, TranslatedLogPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, TranslatedLogPacket::prefix, (StreamCodec)ByteBufCodecs.STRING_UTF8, TranslatedLogPacket::translationKey, (StreamCodec)ByteBufCodecs.STRING_UTF8, TranslatedLogPacket::suffix, (StreamCodec)ByteBufCodecs.BOOL, TranslatedLogPacket::actionBar, TranslatedLogPacket::new);
    public static final CustomPacketPayload.Type<TranslatedLogPacket> ID = new CustomPacketPayload.Type(EffortlessBuilding.asResource("translated_log"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(TranslatedLogPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                if (context.player() != null) {
                    Player player = context.player();
                    EffortlessBuilding.logTranslate(player, packet.prefix(), packet.translationKey(), packet.suffix(), packet.actionBar());
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"effortlessbuilding.networking.translated_log.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

