/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.item;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.systems.ServerBuildState;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class AbstractRandomizerBagItem
extends Item {
    private static long currentSeed = 1337L;
    private static final Random rand = new Random(currentSeed);

    public AbstractRandomizerBagItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public abstract int getInventorySize();

    public abstract MenuProvider getContainerProvider(ItemStack var1);

    @Nullable
    public IItemHandler getBagInventory(ItemStack bag) {
        return (IItemHandler)bag.getCapability(Capabilities.ItemHandler.ITEM, null);
    }

    public ItemStack pickRandomStack(IItemHandler bagInventory) {
        int nonempty = 0;
        ArrayList<ItemStack> nonEmptyStacks = new ArrayList<ItemStack>();
        ArrayList<Integer> originalSlots = new ArrayList<Integer>(this.getInventorySize());
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ++nonempty;
            nonEmptyStacks.add(stack);
            originalSlots.add(i);
        }
        if (nonEmptyStacks.size() != originalSlots.size()) {
            throw new Error("NonEmptyStacks and OriginalSlots not same size");
        }
        if (nonempty == 0) {
            return ItemStack.EMPTY;
        }
        int randomSlot = rand.nextInt(nonempty);
        if (randomSlot < 0 || randomSlot > bagInventory.getSlots()) {
            return ItemStack.EMPTY;
        }
        int originalSlot = (Integer)originalSlots.get(randomSlot);
        if (originalSlot < 0 || originalSlot > bagInventory.getSlots()) {
            return ItemStack.EMPTY;
        }
        return bagInventory.getStackInSlot(originalSlot);
    }

    public ItemStack findStack(IItemHandler bagInventory, Item item) {
        for (int i = 0; i < bagInventory.getSlots(); ++i) {
            ItemStack stack = bagInventory.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem() != item) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static void resetRandomness() {
        rand.setSeed(currentSeed);
    }

    public static void renewRandomness() {
        currentSeed = Calendar.getInstance().getTimeInMillis();
        rand.setSeed(currentSeed);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction facing = ctx.getClickedFace();
        ItemStack item = ctx.getItemInHand();
        Vec3 hitVec = ctx.getClickLocation();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (ctx.getPlayer() != null && ctx.getPlayer().isShiftKeyDown()) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            player.openMenu(this.getContainerProvider(item));
        } else {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (!ServerBuildState.isLikeVanilla(player)) {
                return InteractionResult.FAIL;
            }
            ItemStack bag = ctx.getItemInHand();
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return InteractionResult.FAIL;
            }
            ItemStack toPlace = this.pickRandomStack(bagInventory);
            if (toPlace.isEmpty()) {
                return InteractionResult.FAIL;
            }
            BlockPlaceContext blockItemUseContext = new BlockPlaceContext(new UseOnContext(player, ctx.getHand(), new BlockHitResult(hitVec, facing, pos, false)));
            if (!world.getBlockState(pos).canBeReplaced(blockItemUseContext)) {
                pos = pos.relative(facing);
            }
            BlockState blockState = Block.byItem((Item)toPlace.getItem()).getStateForPlacement(blockItemUseContext);
            BlockEntry blockEntry = new BlockEntry(pos, blockState, toPlace.getItem());
            BlockSet blockSet = new BlockSet(List.of(blockEntry), pos, pos, false);
            EffortlessBuilding.SERVER_BLOCK_PLACER.applyBlockSet(player, blockSet);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack bag = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (world.isClientSide) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)bag);
            }
        } else {
            IItemHandler bagInventory = this.getBagInventory(bag);
            if (bagInventory == null) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)bag);
            }
            ItemStack toUse = this.pickRandomStack(bagInventory);
            if (toUse.isEmpty()) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)bag);
            }
            return toUse.use(world, player, hand);
        }
        player.openMenu(this.getContainerProvider(bag));
        return new InteractionResultHolder(InteractionResult.PASS, (Object)bag);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "*Experimental* Only works in singleplayer")));
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Rightclick" + String.valueOf(ChatFormatting.GRAY) + " to place a random block")));
        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.BLUE) + "Sneak + rightclick" + String.valueOf(ChatFormatting.GRAY) + " to open inventory")));
    }
}

