/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.attachment.PowerLevel;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.network.message.ModifierSettingsPacket;
import nl.requios.effortlessbuilding.network.message.PowerLevelPacket;
import nl.requios.effortlessbuilding.systems.ServerBuildState;
import nl.requios.effortlessbuilding.utilities.PowerLevelCommand;

@EventBusSubscriber
public class CommonEvents {
    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        PowerLevelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level.isClientSide) {
            return;
        }
        if (!level.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        EffortlessBuilding.SERVER_BLOCK_PLACER.tick();
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        if (EffortlessBuilding.SERVER_BLOCK_PLACER.isPlacingOrBreakingBlocks()) {
            return;
        }
        if (!ServerBuildState.isLikeVanilla(player) && CommonEvents.isPlayerHoldingBlock(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        if (EffortlessBuilding.SERVER_BLOCK_PLACER.isPlacingOrBreakingBlocks()) {
            return;
        }
        PowerLevel powerLevel = (PowerLevel)player.getData(EffortlessBuilding.POWER_LEVEL);
        if (!ServerBuildState.isLikeVanilla(player) && powerLevel.canBreakFar(player)) {
            event.setCanceled(true);
        }
    }

    private static boolean isPlayerHoldingBlock(Player player) {
        ItemStack currentItemStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        return currentItemStack.getItem() instanceof BlockItem || CompatHelper.isItemBlockProxy(currentItemStack) && !player.isShiftKeyDown();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            return;
        }
        ServerBuildState.handleNewPlayer(player);
        ((ServerPlayer)player).connection.send((CustomPacketPayload)new ModifierSettingsPacket(player));
        PowerLevel powerLevel = (PowerLevel)player.getData(EffortlessBuilding.POWER_LEVEL);
        ((ServerPlayer)player).connection.send((CustomPacketPayload)new PowerLevelPacket(powerLevel.getPowerLevel()));
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        if (event.isWasDeath() && event.getOriginal().hasData(EffortlessBuilding.POWER_LEVEL)) {
            event.getEntity().setData(EffortlessBuilding.POWER_LEVEL, (Object)((PowerLevel)event.getOriginal().getData(EffortlessBuilding.POWER_LEVEL)));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            EffortlessBuilding.log("PlayerLoggedOutEvent triggers on client side");
            return;
        }
        EffortlessBuilding.UNDO_REDO.clear(player);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            EffortlessBuilding.log("PlayerRespawnEvent triggers on client side");
            return;
        }
        ServerBuildState.handleNewPlayer(player);
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() instanceof FakePlayer) {
            return;
        }
        Player player = event.getEntity();
        if (player.getCommandSenderWorld().isClientSide) {
            EffortlessBuilding.log("PlayerChangedDimensionEvent triggers on client side");
            return;
        }
        EffortlessBuilding.UNDO_REDO.clear(player);
    }

    public static class ModBusEvents {
    }
}

