/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import org.joml.Matrix4f;

public class AllIcons
implements ScreenElement {
    public static final ResourceLocation ICON_ATLAS = EffortlessBuilding.asResource("textures/gui/icons.png");
    public static final int ICON_ATLAS_SIZE = 256;
    private static int x = 0;
    private static int y = -1;
    private int iconX;
    private int iconY;
    public static final AllIcons I_SETTINGS = AllIcons.newRow();
    public static final AllIcons I_UNDO = AllIcons.next();
    public static final AllIcons I_REDO = AllIcons.next();
    public static final AllIcons I_REPLACE = AllIcons.next();
    public static final AllIcons I_REPLACE_AIR = AllIcons.next();
    public static final AllIcons I_REPLACE_BLOCKS_AND_AIR = AllIcons.next();
    public static final AllIcons I_REPLACE_BLOCKS = AllIcons.next();
    public static final AllIcons I_REPLACE_OFFHAND_FILTERED = AllIcons.next();
    public static final AllIcons I_PROTECT_TILE_ENTITIES = AllIcons.next();
    public static final AllIcons I_DISABLE = AllIcons.newRow();
    public static final AllIcons I_SINGLE = AllIcons.next();
    public static final AllIcons I_LINE = AllIcons.next();
    public static final AllIcons I_WALL = AllIcons.next();
    public static final AllIcons I_FLOOR = AllIcons.next();
    public static final AllIcons I_CUBE = AllIcons.next();
    public static final AllIcons I_DIAGONAL_LINE = AllIcons.next();
    public static final AllIcons I_DIAGONAL_WALL = AllIcons.next();
    public static final AllIcons I_SLOPED_FLOOR = AllIcons.next();
    public static final AllIcons I_CIRCLE = AllIcons.next();
    public static final AllIcons I_CYLINDER = AllIcons.next();
    public static final AllIcons I_SPHERE = AllIcons.next();
    public static final AllIcons I_PYRAMID = AllIcons.next();
    public static final AllIcons I_CONE = AllIcons.next();
    public static final AllIcons I_DOME = AllIcons.next();
    public static final AllIcons I_NORMAL_SPEED = AllIcons.newRow();
    public static final AllIcons I_FAST_SPEED = AllIcons.next();
    public static final AllIcons I_FILLED = AllIcons.next();
    public static final AllIcons I_HOLLOW = AllIcons.next();
    public static final AllIcons I_CUBE_FILLED = AllIcons.next();
    public static final AllIcons I_CUBE_HOLLOW = AllIcons.next();
    public static final AllIcons I_CUBE_SKELETON = AllIcons.next();
    public static final AllIcons I_SHORT_EDGE = AllIcons.next();
    public static final AllIcons I_LONG_EDGE = AllIcons.next();
    public static final AllIcons I_CIRCLE_START_CORNER = AllIcons.next();
    public static final AllIcons I_CIRCLE_START_CENTER = AllIcons.next();
    public static final AllIcons I_THICKNESS_1 = AllIcons.next();
    public static final AllIcons I_THICKNESS_3 = AllIcons.next();
    public static final AllIcons I_THICKNESS_5 = AllIcons.next();
    public static final AllIcons I_PLAYER = AllIcons.newRow();
    public static final AllIcons I_BLOCK_CENTER = AllIcons.next();
    public static final AllIcons I_BLOCK_CORNER = AllIcons.next();
    public static final AllIcons I_HIDE_LINES = AllIcons.next();
    public static final AllIcons I_SHOW_LINES = AllIcons.next();
    public static final AllIcons I_HIDE_AREAS = AllIcons.next();
    public static final AllIcons I_SHOW_AREAS = AllIcons.next();
    public static final AllIcons I_X_OFF = AllIcons.next();
    public static final AllIcons I_X_ON = AllIcons.next();
    public static final AllIcons I_Y_OFF = AllIcons.next();
    public static final AllIcons I_Y_ON = AllIcons.next();
    public static final AllIcons I_Z_OFF = AllIcons.next();
    public static final AllIcons I_Z_ON = AllIcons.next();
    public static final AllIcons I_ALTERNATE_OFF = AllIcons.next();
    public static final AllIcons I_ALTERNATE_ON = AllIcons.next();

    public AllIcons(int x, int y) {
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    private static AllIcons next() {
        return new AllIcons(++x, y);
    }

    private static AllIcons newRow() {
        x = 0;
        return new AllIcons(0, ++y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(ICON_ATLAS, x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 256, 256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.getBuffer(RenderType.textSeeThrough((ResourceLocation)ICON_ATLAS));
        Matrix4f matrix = ms.last().pose();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX * 1.0f / 256.0f;
        float u2 = (float)(this.iconX + 16) * 1.0f / 256.0f;
        float v1 = (float)this.iconY * 1.0f / 256.0f;
        float v2 = (float)(this.iconY + 16) * 1.0f / 256.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.addVertex(matrix, (float)vec.x, (float)vec.y, (float)vec.z).setColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).setUv(u, v).setLight(light);
    }

    @OnlyIn(value=Dist.CLIENT)
    public DelegatedStencilElement asStencil() {
        return (DelegatedStencilElement)new DelegatedStencilElement().withStencilRenderer((ms, w, h, alpha) -> this.render(ms, 0, 0)).withBounds(16, 16);
    }
}

