/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.gui;

import com.yukami.backpacktab.client.config.TabConfig;
import com.yukami.backpacktab.client.gui.TabRenderer;
import com.yukami.backpacktab.client.gui.TabSwitcher;
import com.yukami.backpacktab.client.tabs.BackpackTab;
import com.yukami.backpacktab.client.tabs.ContainerTab;
import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.tabs.PlayerTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.IBackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

@EventBusSubscriber(modid="yukamibackpacktab", value={Dist.CLIENT})
public class TabManager {
    private static AbstractContainerScreen<?> currentScreen = null;
    private static BlockPos storedBlockPos = null;
    private static Block storedBlockType = null;
    private static boolean isTabSwitching = false;
    private static final List<InventoryTab> activeTabs = new ArrayList<InventoryTab>();
    private static List<? extends String> cachedAdditionalTabBlocks = null;

    public static List<InventoryTab> getAvailableTabs(Player player, AbstractContainerScreen<?> screen) {
        ArrayList<InventoryTab> tabs = new ArrayList<InventoryTab>();
        BackpackTab equippedBackpack = TabManager.getEquippedBackpackTab(player);
        if (equippedBackpack == null) {
            return tabs;
        }
        if (storedBlockPos != null && TabManager.isBackpackBlock(player.level(), storedBlockPos)) {
            tabs.add(new ContainerTab(storedBlockPos));
            tabs.add(equippedBackpack);
            return tabs;
        }
        if (screen instanceof InventoryScreen) {
            tabs.add(new PlayerTab());
        } else if (storedBlockPos != null) {
            tabs.add(new ContainerTab(storedBlockPos));
        } else {
            tabs.add(new PlayerTab());
        }
        tabs.add(equippedBackpack);
        return tabs;
    }

    public static void updateActiveStates(List<InventoryTab> tabs, AbstractContainerScreen<?> screen) {
        tabs.forEach(tab -> tab.setActive(tab.matchesCurrentScreen(screen)));
    }

    private static BackpackTab getEquippedBackpackTab(Player player) {
        try {
            BackpackTab[] foundTab = new BackpackTab[]{null};
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryName, identifier, slot) -> {
                if ("main".equals(inventoryName)) {
                    return false;
                }
                foundTab[0] = new BackpackTab(backpack);
                return true;
            });
            return foundTab[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isStoredBlockValid() {
        if (storedBlockPos == null || storedBlockType == null) {
            return false;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        Level world = player.level();
        if (world == null) {
            return false;
        }
        BlockState blockState = world.getBlockState(storedBlockPos);
        if (blockState.getBlock() != storedBlockType) {
            return false;
        }
        double distanceSq = player.distanceToSqr((double)storedBlockPos.getX() + 0.5, (double)storedBlockPos.getY() + 0.5, (double)storedBlockPos.getZ() + 0.5);
        return distanceSq <= 64.0;
    }

    private static boolean isContainerBlock(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockState blockState = world.getBlockState(pos);
        if (blockState.getBlock() instanceof BackpackBlock) {
            return true;
        }
        if (TabManager.isAdditionalTabBlock(blockState)) {
            return true;
        }
        try {
            return blockState.getMenuProvider(world, pos) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isBackpackBlock(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockState blockState = world.getBlockState(pos);
        return blockState.getBlock() instanceof BackpackBlock;
    }

    private static boolean isAdditionalTabBlock(BlockState blockState) {
        try {
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
            String blockIdString = blockId.toString();
            for (String string : TabManager.getAdditionalTabBlocks()) {
                if (string == null || !string.trim().equals(blockIdString)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<? extends String> getAdditionalTabBlocks() {
        if (cachedAdditionalTabBlocks == null) {
            cachedAdditionalTabBlocks = TabConfig.getAdditionalTabBlocks();
        }
        return cachedAdditionalTabBlocks;
    }

    private static boolean isScreenAllowedForTabs(AbstractContainerScreen<?> screen) {
        if (screen instanceof InventoryScreen) {
            return true;
        }
        if (screen instanceof IBackpackScreen) {
            return true;
        }
        return storedBlockPos != null && TabManager.isStoredBlockValid();
    }

    private static void handleInvalidBlock() {
        LocalPlayer player;
        if (currentScreen instanceof IBackpackScreen && (player = Minecraft.getInstance().player) != null) {
            player.closeContainer();
        }
        TabManager.resetState();
    }

    private static void resetState() {
        storedBlockPos = null;
        storedBlockType = null;
        currentScreen = null;
        isTabSwitching = false;
        activeTabs.clear();
        CarriedItemUtil.reset();
        TabRenderer.invalidateCache();
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().isClientSide()) {
            BlockPos clickedPos = event.getPos();
            Level world = event.getLevel();
            if (TabManager.isContainerBlock(world, clickedPos)) {
                storedBlockPos = clickedPos;
                storedBlockType = world.getBlockState(clickedPos).getBlock();
            }
        }
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        LocalPlayer player;
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        currentScreen = containerScreen;
        if (!isTabSwitching) {
            activeTabs.clear();
        }
        if ((player = Minecraft.getInstance().player) != null && !isTabSwitching) {
            activeTabs.clear();
            activeTabs.addAll(TabManager.getAvailableTabs((Player)player, containerScreen));
            TabManager.updateActiveStates(activeTabs, containerScreen);
        }
        isTabSwitching = false;
        if (player instanceof LocalPlayer) {
            LocalPlayer localPlayer = player;
            MultiPlayerGameMode gameMode = Minecraft.getInstance().gameMode;
            if (gameMode != null) {
                TabSwitcher.restoreCarriedItems(localPlayer, gameMode);
            }
        }
    }

    @SubscribeEvent
    public static void onScreenRender(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (!(abstractContainerScreen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = abstractContainerScreen;
        if (!TabManager.isScreenAllowedForTabs(containerScreen)) {
            return;
        }
        if (containerScreen != currentScreen && !(containerScreen instanceof InventoryScreen)) {
            return;
        }
        if (storedBlockPos != null && !TabManager.isStoredBlockValid()) {
            TabManager.handleInvalidBlock();
            return;
        }
        TabRenderer.renderTabs(event.getGuiGraphics(), containerScreen, event.getMouseX(), event.getMouseY());
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            return;
        }
        AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
        if (containerScreen != currentScreen) {
            return;
        }
        if (!TabManager.isScreenAllowedForTabs(containerScreen)) {
            return;
        }
        isTabSwitching = true;
        if (TabRenderer.handleTabClick(event.getMouseX(), event.getMouseY(), event.getButton(), containerScreen)) {
            event.setCanceled(true);
        } else {
            isTabSwitching = false;
        }
    }

    @SubscribeEvent
    public static void onScreenClose(ScreenEvent.Closing event) {
        if (event.getScreen() == currentScreen) {
            if (!isTabSwitching) {
                TabManager.resetState();
                Screen screen = event.getScreen();
                if (screen instanceof AbstractContainerScreen) {
                    AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
                    LocalPlayer player = Minecraft.getInstance().player;
                    if (player != null && screen2 instanceof InventoryScreen && CarriedItemUtil.isStashed() && player.containerMenu.getCarried().isEmpty()) {
                        player.containerMenu.setCarried(ItemStack.EMPTY);
                    }
                }
                CarriedItemUtil.reset();
            }
            currentScreen = null;
        }
    }

    public static List<InventoryTab> getActiveTabs() {
        return new ArrayList<InventoryTab>(activeTabs);
    }

    public static BlockPos getStoredBlockPos() {
        return storedBlockPos;
    }

    public static Block getStoredBlockType() {
        return storedBlockType;
    }

    public static void reset() {
        TabManager.resetState();
    }
}

