/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.tabs;

import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.IBackpackScreen;

public class ContainerTab
implements InventoryTab {
    private final BlockPos containerPos;
    private boolean active = false;

    public ContainerTab(BlockPos containerPos) {
        this.containerPos = containerPos;
    }

    @Override
    public ItemStack getTabIcon() {
        ClientLevel world;
        if (this.containerPos != null && (world = Minecraft.getInstance().level) != null) {
            BlockState blockState = world.getBlockState(this.containerPos);
            if (blockState.getBlock() instanceof BackpackBlock) {
                try {
                    BackpackBlockEntity backpackBE;
                    ItemStack backpackStack;
                    BlockEntity blockEntity = world.getBlockEntity(this.containerPos);
                    if (blockEntity instanceof BackpackBlockEntity && !(backpackStack = (backpackBE = (BackpackBlockEntity)blockEntity).getBackpackWrapper().getBackpack()).isEmpty()) {
                        return backpackStack;
                    }
                }
                catch (Exception blockEntity) {
                    // empty catch block
                }
            }
            ItemStack icon = new ItemStack((ItemLike)blockState.getBlock());
            return icon;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Component getHoverText() {
        ItemStack icon = this.getTabIcon();
        return icon.isEmpty() ? Component.literal((String)"Container") : icon.getHoverName();
    }

    @Override
    public void open(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
        if (player == null || gameMode == null || !(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        try {
            if (this.containerPos != null) {
                CarriedItemUtil.stashCarriedItem(localPlayer, gameMode, handler);
                if (handler != null && localPlayer.connection != null) {
                    localPlayer.connection.send((Packet)new ServerboundContainerClosePacket(handler.containerId));
                }
                Vec3 hitVec = Vec3.atCenterOf((Vec3i)this.containerPos);
                BlockHitResult hitResult = new BlockHitResult(hitVec, Direction.UP, this.containerPos, false);
                gameMode.useItemOn(localPlayer, InteractionHand.MAIN_HAND, hitResult);
            } else {
                Minecraft.getInstance().setScreen(null);
            }
        }
        catch (Exception e) {
            Minecraft.getInstance().setScreen(null);
        }
    }

    @Override
    public void close(Player player, Level world, AbstractContainerMenu handler, MultiPlayerGameMode gameMode) {
    }

    @Override
    public boolean matchesCurrentScreen(AbstractContainerScreen<?> screen) {
        BlockState blockState;
        if (this.containerPos == null) {
            return false;
        }
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && (blockState = world.getBlockState(this.containerPos)).getBlock() instanceof BackpackBlock) {
            return screen instanceof IBackpackScreen;
        }
        return !(screen instanceof IBackpackScreen);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

