/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpawnExtras {
    public static final SpawnUtil.Strategy ON_TOP_OF_COLLIDER_NO_LEAVES = (level, pos, target, mutable, state) -> state.getCollisionShape((BlockGetter)level, mutable).isEmpty() && !target.is(BlockTags.LEAVES) && Block.isFaceFull((VoxelShape)target.getCollisionShape((BlockGetter)level, pos), (Direction)Direction.UP);

    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> entityType, MobSpawnType spawnType, ServerLevel level, BlockPos pos, int attempts, int spread, int yOffset, SpawnUtil.Strategy strategy, boolean checkForCollisions) {
        BlockPos.MutableBlockPos mutable = pos.mutable();
        for (int i = 0; i < attempts; ++i) {
            Mob mob;
            int xOffset = Mth.randomBetweenInclusive((RandomSource)level.random, (int)(-spread), (int)spread);
            int zOffset = Mth.randomBetweenInclusive((RandomSource)level.random, (int)(-spread), (int)spread);
            mutable.setWithOffset((Vec3i)pos, xOffset, yOffset, zOffset);
            if (!level.getWorldBorder().isWithinBounds((BlockPos)mutable) || !SpawnExtras.moveToPossibleSpawnPosition(level, yOffset, mutable, strategy) || checkForCollisions && !level.noCollision(entityType.getSpawnAABB((double)mutable.getX() + 0.5, (double)mutable.getY(), (double)mutable.getZ() + 0.5)) || (mob = (Mob)entityType.create(level, null, (BlockPos)mutable, spawnType, false, false)) == null) continue;
            if (mob.checkSpawnRules((LevelAccessor)level, spawnType) && mob.checkSpawnObstruction((LevelReader)level)) {
                level.addFreshEntityWithPassengers((Entity)mob);
                mob.playAmbientSound();
                return Optional.of(mob);
            }
            mob.discard();
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(ServerLevel level, int yOffset, BlockPos.MutableBlockPos pos, SpawnUtil.Strategy strategy) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)pos);
        BlockState state = level.getBlockState((BlockPos)mutable);
        for (int i = yOffset; i >= -yOffset; --i) {
            pos.move(Direction.DOWN);
            mutable.setWithOffset((Vec3i)pos, Direction.UP);
            BlockState target = level.getBlockState((BlockPos)pos);
            if (strategy.canSpawnOn(level, (BlockPos)pos, target, (BlockPos)mutable, state)) {
                pos.move(Direction.UP);
                return true;
            }
            state = target;
        }
        return false;
    }
}

