/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.common.entities;

import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhast;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Leashable.class})
public interface LeashableMixin {
    @Invoker
    public static void callRestoreLeashFromSave(Entity entity, Leashable.LeashData leashData) {
    }

    @Invoker
    public static void callDropLeash(Entity entity, boolean broadcast, boolean drop) {
    }

    @Inject(method={"tickLeash(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static <E extends Entity> void vb$tickLeash(E entity, CallbackInfo ci) {
        if (entity instanceof HappyGhast) {
            ci.cancel();
            Leashable.LeashData data = ((Leashable)entity).getLeashData();
            if (data != null && data.delayedLeashInfo != null) {
                LeashableMixin.callRestoreLeashFromSave(entity, data);
            }
            if (data != null && data.leashHolder != null) {
                Entity holder;
                if (!entity.isAlive() || !data.leashHolder.isAlive()) {
                    LeashableMixin.callDropLeash(entity, true, true);
                }
                if ((holder = ((Leashable)entity).getLeashHolder()) != null && holder.level() == entity.level()) {
                    float distanceFromHolder = entity.distanceTo(holder);
                    if (!((Leashable)entity).handleLeashAtDistance(holder, distanceFromHolder)) {
                        return;
                    }
                    if ((double)distanceFromHolder > 16.0) {
                        ((Leashable)entity).leashTooFarBehaviour();
                    } else if ((double)distanceFromHolder > 12.0) {
                        ((Leashable)entity).elasticRangeLeashBehaviour(holder, distanceFromHolder);
                        entity.checkSlowFallDistance();
                    } else {
                        ((Leashable)entity).closeRangeLeashBehaviour(holder);
                    }
                }
            }
        }
    }
}

