/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.blocks;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.registries.ModBlockStateProperties;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HangingMossBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<HangingMossBlock> CODEC = HangingMossBlock.simpleCodec(HangingMossBlock::new);
    private static final VoxelShape TIP_SHAPE = Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty TIP = ModBlockStateProperties.TIP;

    public MapCodec<HangingMossBlock> codec() {
        return CODEC;
    }

    public HangingMossBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TIP, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)TIP) != false ? TIP_SHAPE : BASE_SHAPE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockState aboveState;
        if (random.nextInt(500) == 0 && ((aboveState = level.getBlockState(pos.above())).is(ModBlockTags.PALE_OAK_LOGS) || aboveState.is(ModBlocks.PALE_OAK_LEAVES.get()))) {
            level.playLocalSound((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ModSoundEvents.PALE_HANGING_MOSS_IDLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return this.canStayAtPosition((BlockGetter)level, pos);
    }

    private boolean canStayAtPosition(BlockGetter level, BlockPos pos) {
        BlockState aboveState;
        BlockPos above = pos.above();
        return MultifaceBlock.canAttachTo((BlockGetter)level, (Direction)Direction.UP, (BlockPos)above, (BlockState)(aboveState = level.getBlockState(above))) || aboveState.is(ModBlocks.PALE_HANGING_MOSS.get());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.canStayAtPosition((BlockGetter)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return (BlockState)state.setValue((Property)TIP, (Comparable)Boolean.valueOf(!level.getBlockState(pos.below()).is((Block)this)));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canStayAtPosition((BlockGetter)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return this.canGrowInto(level.getBlockState(this.getTip((BlockGetter)level, pos).below()));
    }

    private boolean canGrowInto(BlockState state) {
        return state.isAir();
    }

    public BlockPos getTip(BlockGetter level, BlockPos pos) {
        BlockState state;
        BlockPos.MutableBlockPos position = pos.mutable();
        do {
            position.move(Direction.DOWN);
        } while ((state = level.getBlockState((BlockPos)position)).is((Block)this));
        return position.relative(Direction.UP).immutable();
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos tipPos = this.getTip((BlockGetter)level, pos).below();
        if (this.canGrowInto(level.getBlockState(tipPos))) {
            level.setBlockAndUpdate(tipPos, (BlockState)state.setValue((Property)TIP, (Comparable)Boolean.valueOf(true)));
        }
    }
}

