/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.particles;

import com.blackgear.vanillabackport.client.level.particles.particleoptions.TrailParticleOption;
import com.blackgear.vanillabackport.core.util.ColorUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrailParticle
extends TextureSheetParticle {
    private final Vec3 target;

    protected TrailParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Vec3 target, int color) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        color = ColorUtils.scaleRGB(color, 0.875f + this.random.nextFloat() * 0.25f, 0.875f + this.random.nextFloat() * 0.25f, 0.875f + this.random.nextFloat() * 0.25f);
        this.rCol = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        this.gCol = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        this.bCol = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        this.quadSize = 0.26f;
        this.target = target;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            int ageInTicks = this.lifetime - this.age;
            double deltaTime = 1.0 / (double)ageInTicks;
            this.x = Mth.lerp((double)deltaTime, (double)this.x, (double)this.target.x());
            this.y = Mth.lerp((double)deltaTime, (double)this.y, (double)this.target.y());
            this.z = Mth.lerp((double)deltaTime, (double)this.z, (double)this.target.z());
        }
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Provider(SpriteSet sprites) implements ParticleProvider<TrailParticleOption>
    {
        public Particle createParticle(TrailParticleOption option, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TrailParticle particle = new TrailParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, option.target(), option.color());
            particle.pickSprite(this.sprites);
            particle.setLifetime(option.duration());
            return particle;
        }
    }
}

