/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.model;

import com.blackgear.vanillabackport.client.level.entities.animation.CreakingAnimation;
import com.blackgear.vanillabackport.common.level.entities.creaking.Creaking;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreakingModel<T extends Creaking>
extends HierarchicalModel<T> {
    public static final List<ModelPart> NO_PARTS = List.of();
    private final ModelPart root;
    private final ModelPart head;
    private final List<ModelPart> headParts;
    private boolean eyesGlowing;

    public CreakingModel(ModelPart root) {
        this.root = root.getChild("root");
        ModelPart upperBody = this.root.getChild("upper_body");
        this.head = upperBody.getChild("head");
        this.headParts = List.of(this.head);
    }

    private static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition base = mesh.getRoot();
        PartDefinition root = base.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upperBody = root.addOrReplaceChild("upper_body", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)-19.0f, (float)0.0f));
        upperBody.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -10.0f, -3.0f, 6.0f, 10.0f, 6.0f).texOffs(28, 31).addBox(-3.0f, -13.0f, -3.0f, 6.0f, 3.0f, 6.0f).texOffs(12, 40).addBox(3.0f, -13.0f, 0.0f, 9.0f, 14.0f, 0.0f).texOffs(34, 12).addBox(-12.0f, -14.0f, 0.0f, 9.0f, 14.0f, 0.0f), PartPose.offset((float)-3.0f, (float)-11.0f, (float)0.0f));
        upperBody.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, -3.0f, -3.0f, 6.0f, 13.0f, 5.0f).texOffs(24, 0).addBox(-6.0f, -4.0f, -3.0f, 6.0f, 7.0f, 5.0f), PartPose.offset((float)0.0f, (float)-7.0f, (float)1.0f));
        upperBody.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(22, 13).addBox(-2.0f, -1.5f, -1.5f, 3.0f, 21.0f, 3.0f).texOffs(46, 0).addBox(-2.0f, 19.5f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)-7.0f, (float)-9.5f, (float)1.5f));
        upperBody.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(30, 40).addBox(0.0f, -1.0f, -1.5f, 3.0f, 16.0f, 3.0f).texOffs(52, 12).addBox(0.0f, -5.0f, -1.5f, 3.0f, 4.0f, 3.0f).texOffs(52, 19).addBox(0.0f, 15.0f, -1.5f, 3.0f, 4.0f, 3.0f), PartPose.offset((float)6.0f, (float)-9.0f, (float)0.5f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(42, 40).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 16.0f, 3.0f).texOffs(45, 55).addBox(-1.5f, 15.7f, -4.5f, 5.0f, 0.0f, 9.0f), PartPose.offset((float)1.5f, (float)-16.0f, (float)0.5f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 34).addBox(-3.0f, -1.5f, -1.5f, 3.0f, 19.0f, 3.0f).texOffs(45, 46).addBox(-5.0f, 17.2f, -4.5f, 5.0f, 0.0f, 9.0f).texOffs(12, 34).addBox(-3.0f, -4.5f, -1.5f, 3.0f, 3.0f, 3.0f), PartPose.offset((float)-1.0f, (float)-17.5f, (float)0.5f));
        return mesh;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = CreakingModel.createMesh();
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        this.eyesGlowing = ((Creaking)((Object)entity)).isTearingDown() ? ((Creaking)((Object)entity)).hasGlowingEyes() : ((Creaking)((Object)entity)).isActive();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        if (((Creaking)((Object)entity)).canMove()) {
            this.animateWalk(CreakingAnimation.CREAKING_WALK, limbSwing, limbSwingAmount, 1.0f, 1.0f);
        }
        this.animate(((Creaking)((Object)entity)).attackAnimationState, CreakingAnimation.CREAKING_ATTACK, ageInTicks);
        this.animate(((Creaking)((Object)entity)).invulnerabilityAnimationState, CreakingAnimation.CREAKING_INVULNERABLE, ageInTicks);
        this.animate(((Creaking)((Object)entity)).deathAnimationState, CreakingAnimation.CREAKING_DEATH, ageInTicks);
    }

    public List<ModelPart> getHeadParts() {
        return !this.eyesGlowing ? NO_PARTS : this.headParts;
    }
}

