/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.generator;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ItemExistsCondition;

public class TitaniumShapedRecipeBuilder
extends ShapedRecipeBuilder {
    private ResourceLocation resourceLocation;
    private final List<ICondition> conditions;
    private boolean criterion;

    public TitaniumShapedRecipeBuilder(RecipeCategory recipeCategory, ItemLike resultIn, int countIn) {
        super(recipeCategory, resultIn, countIn);
        this.resourceLocation = BuiltInRegistries.ITEM.getKey((Object)resultIn.asItem());
        this.conditions = new ArrayList<ICondition>();
        this.condition((ICondition)new ItemExistsCondition(this.resourceLocation));
    }

    public static TitaniumShapedRecipeBuilder shapedRecipe(ItemLike resultIn) {
        return TitaniumShapedRecipeBuilder.shapedRecipe(resultIn, 1);
    }

    public static TitaniumShapedRecipeBuilder shapedRecipe(ItemLike resultIn, int countIn) {
        return new TitaniumShapedRecipeBuilder(RecipeCategory.MISC, resultIn, countIn);
    }

    public void save(RecipeOutput pRecipeOutput) {
        super.save(pRecipeOutput.withConditions((ICondition[])this.conditions.toArray(ICondition[]::new)));
    }

    public ShapedRecipeBuilder define(Character symbol, TagKey<Item> tagIn) {
        if (!this.criterion) {
            this.criterion = true;
            this.unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tagIn).build()}));
        }
        return super.define(symbol, tagIn);
    }

    public ShapedRecipeBuilder define(Character symbol, Ingredient ingredientIn) {
        if (!this.criterion) {
            this.criterion = true;
            this.unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{ingredientIn.getItems()[0].getItem()}).build()}));
        }
        return super.define(symbol, ingredientIn);
    }

    public TitaniumShapedRecipeBuilder setName(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    public TitaniumShapedRecipeBuilder condition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }
}

