/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.module;

import com.hrznstudio.titanium.block.BasicBlock;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.block.tile.PoweredTile;
import com.hrznstudio.titanium.module.BlockWithTile;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class DeferredRegistryHelper {
    private final String modId;
    private final HashMap<ResourceKey<? extends Registry<?>>, DeferredRegister<?>> registries;
    private final IEventBus bus;

    public DeferredRegistryHelper(String modId) {
        this.modId = modId;
        this.registries = new HashMap();
        this.bus = ((ModContainer)ModList.get().getModContainerById(modId).orElseThrow()).getEventBus();
    }

    public <T> DeferredRegister<T> addRegistry(ResourceKey<? extends Registry<T>> key) {
        DeferredRegister deferredRegister = DeferredRegister.create(key, (String)this.modId);
        deferredRegister.register(this.bus);
        this.registries.put(key, deferredRegister);
        return deferredRegister;
    }

    private <T> DeferredHolder<T, T> register(ResourceKey<? extends Registry<T>> key, String name, Supplier<T> object) {
        DeferredRegister<T> deferredRegister = this.getRegistry(key);
        return deferredRegister.register(name, object);
    }

    public <T> DeferredRegister<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        DeferredRegister<?> deferredRegister = this.registries.get(key);
        if (deferredRegister == null) {
            this.addRegistry(key);
            deferredRegister = this.registries.get(key);
        }
        return deferredRegister;
    }

    public <T> DeferredHolder<T, T> registerGeneric(ResourceKey<? extends Registry<T>> key, String name, Supplier<T> object) {
        return this.register(key, name, object);
    }

    public <T, R extends T> DeferredHolder<T, R> registerTyped(ResourceKey<? extends Registry<T>> key, String name, Supplier<R> object) {
        return this.register(key, name, object);
    }

    public DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> registerBlockEntityType(String name, Supplier<BlockEntityType<?>> object) {
        ResourceKey key = Registries.BLOCK_ENTITY_TYPE;
        DeferredRegister<?> deferredRegister = this.registries.get(key);
        if (deferredRegister == null) {
            this.addRegistry(key);
            deferredRegister = this.registries.get(key);
        }
        return deferredRegister.register(name, object);
    }

    public Holder<EntityType<?>> registerEntityType(String name, Supplier<EntityType<?>> object) {
        ResourceKey key = Registries.ENTITY_TYPE;
        DeferredRegister<?> deferredRegister = this.registries.get(key);
        if (deferredRegister == null) {
            this.addRegistry(key);
            deferredRegister = this.registries.get(key);
        }
        return deferredRegister.register(name, object);
    }

    public DeferredHolder<Block, Block> registerBlockWithItem(String name, Supplier<? extends BasicBlock> blockSupplier, @Nullable TitaniumTab tab) {
        DeferredHolder<Block, Block> blockRegistryObject = this.registerGeneric(Registries.BLOCK, name, blockSupplier::get);
        this.registerGeneric(Registries.ITEM, name, () -> {
            BlockItem item = new BlockItem((Block)blockRegistryObject.get(), new Item.Properties());
            if (tab != null) {
                tab.getTabList().add((Item)item);
            }
            return item;
        });
        return blockRegistryObject;
    }

    public DeferredHolder<Block, Block> registerBlockWithItem(String name, Supplier<? extends Block> blockSupplier, Function<DeferredHolder<Block, Block>, Supplier<Item>> itemSupplier, TitaniumTab tab) {
        DeferredHolder<Block, Block> block = this.registerGeneric(Registries.BLOCK, name, blockSupplier::get);
        this.registerGeneric(Registries.ITEM, name, () -> {
            Item item = (Item)((Supplier)itemSupplier.apply(block)).get();
            if (tab != null) {
                tab.getTabList().add(item);
            }
            return item;
        });
        return block;
    }

    public void registerCapabilities(Holder<BlockEntityType<?>> type) {
        this.bus.addListener(event -> {
            event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)type.value(), (object, context) -> {
                if (object instanceof PoweredTile) {
                    PoweredTile powered = (PoweredTile)object;
                    return powered.getEnergyStorage();
                }
                return null;
            });
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)type.value(), (object, context) -> {
                if (object instanceof ActiveTile) {
                    ActiveTile tile = (ActiveTile)object;
                    return tile.getFluidHandler((Direction)context);
                }
                return null;
            });
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)type.value(), (object, context) -> {
                if (object instanceof ActiveTile) {
                    ActiveTile tile = (ActiveTile)object;
                    return tile.getItemHandler((Direction)context);
                }
                return null;
            });
        });
    }

    public BlockWithTile registerBlockWithTile(String name, Supplier<BasicTileBlock<?>> blockSupplier, @Nullable TitaniumTab tab) {
        DeferredHolder<Block, Block> blockRegistryObject = this.registerBlockWithItem(name, blockSupplier, tab);
        DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> type = this.registerBlockEntityType(name, () -> BlockEntityType.Builder.of(((BasicTileBlock)blockRegistryObject.get()).getTileEntityFactory(), (Block[])new Block[]{(Block)blockRegistryObject.get()}).build(null));
        this.registerCapabilities((Holder<BlockEntityType<?>>)type);
        return new BlockWithTile(blockRegistryObject, type);
    }

    public BlockWithTile registerBlockWithTileItem(String name, Supplier<BasicTileBlock<?>> blockSupplier, Function<DeferredHolder<Block, Block>, Supplier<Item>> itemSupplier, @Nullable TitaniumTab tab) {
        DeferredHolder<Block, Block> blockRegistryObject = this.registerBlockWithItem(name, blockSupplier, itemSupplier, tab);
        DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> type = this.registerBlockEntityType(name, () -> BlockEntityType.Builder.of(((BasicTileBlock)blockRegistryObject.get()).getTileEntityFactory(), (Block[])new Block[]{(Block)blockRegistryObject.get()}).build(null));
        this.registerCapabilities((Holder<BlockEntityType<?>>)type);
        return new BlockWithTile(blockRegistryObject, type);
    }
}

