/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.energy;

import com.hrznstudio.titanium.attachment.StoredEnergyAttachment;
import com.hrznstudio.titanium.item.EnergyItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyStorageItemStack
implements IEnergyStorage {
    private final ItemStack stack;

    public EnergyStorageItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public void putInternal(int energy) {
        this.save(new StoredEnergyAttachment(Math.min(this.getEnergyStored() + energy, this.getMaxEnergyStored()), this.getMaxEnergyStored(), this.getMaxReceive(), this.getMaxExtract()));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxReceive(), maxReceive));
        if (!simulate && energyReceived != 0) {
            this.save(new StoredEnergyAttachment(this.getEnergyStored() + energyReceived, this.getMaxEnergyStored(), this.getMaxReceive(), this.getMaxExtract()));
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxExtract(), maxExtract));
        if (!simulate && this.stack != null && energyExtracted != 0) {
            this.save(new StoredEnergyAttachment(this.getEnergyStored() - energyExtracted, this.getMaxEnergyStored(), this.getMaxReceive(), this.getMaxExtract()));
        }
        return energyExtracted;
    }

    public int getMaxExtract() {
        return this.get().out();
    }

    public int getMaxReceive() {
        return this.get().in();
    }

    public int getEnergyStored() {
        return this.get().stored();
    }

    public int getMaxEnergyStored() {
        return this.get().capacity();
    }

    public boolean canExtract() {
        return this.getMaxExtract() > 0;
    }

    public boolean canReceive() {
        return this.getMaxReceive() > 0;
    }

    public void save(StoredEnergyAttachment attachment) {
        this.stack.set(StoredEnergyAttachment.TYPE, (Object)attachment);
    }

    public StoredEnergyAttachment get() {
        return (StoredEnergyAttachment)this.stack.getOrDefault(StoredEnergyAttachment.TYPE, (Object)new StoredEnergyAttachment((EnergyItem)this.stack.getItem()));
    }
}

