/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.command;

import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.reward.storage.RewardWorldStorage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RewardGrantCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"titanium-rewards-grant").then(Commands.argument((String)"reward", (ArgumentType)new ResourceLocationArgument()).suggests((context, builder) -> SharedSuggestionProvider.suggest(RewardManager.get().getGiver(((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID(), ((CommandSourceStack)context.getSource()).getTextName()).getRewards().stream().map(reward -> reward.getResourceLocation().toString()), (SuggestionsBuilder)builder)).executes(context -> {
            RewardGrantCommand.execute((CommandContext<CommandSourceStack>)context);
            return 1;
        })));
    }

    private static void execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)context.getArgument("reward", ResourceLocation.class);
        for (Reward reward : RewardManager.get().getGiver(((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID(), ((CommandSourceStack)context.getSource()).getTextName()).getRewards()) {
            if (!reward.getResourceLocation().equals((Object)resourceLocation)) continue;
            RewardWorldStorage rewardWorldStorage = RewardWorldStorage.get(((CommandSourceStack)context.getSource()).getLevel());
            rewardWorldStorage.addFree(resourceLocation);
            rewardWorldStorage.setDirty();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"titanium.rewards.granted_success"), true);
            return;
        }
    }
}

