/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class HeartPopParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public HeartPopParticle(ClientLevel level, double x, double y, double z, double ySpeed, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.xd = 0.0;
        this.yd = ySpeed;
        this.zd = 0.0;
        this.lifetime = 5;
        this.speedUpWhenYMotionIsBlocked = true;
        this.quadSize *= 1.5f;
        this.hasPhysics = false;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)((float)this.age + partialTicks / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public record Provider(SpriteSet sprites) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new HeartPopParticle(level, x, y, z, ySpeed, this.sprites);
        }
    }
}

