/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.init.ModParticles;
import einstein.subtle_effects.ticking.tickers.TickerManager;
import einstein.subtle_effects.util.MathUtil;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Panda.class})
public abstract class PandaMixin
extends Animal {
    @Unique
    private final Panda subtleEffects$panda = (Panda)this;

    protected PandaMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyReturnValue(method={"mobInteract"}, at={@At(value="RETURN")})
    private InteractionResult onPandaInteract(InteractionResult result, @Local(argsOnly=true) Player player, @Local(argsOnly=true) InteractionHand hand) {
        Level level = this.subtleEffects$panda.level();
        if (level.isClientSide()) {
            if (result != InteractionResult.PASS || !ModConfigs.ENTITIES.featherTicklingPandas || this.subtleEffects$panda.isSneezing() || !this.subtleEffects$panda.canPerformAction()) {
                return result;
            }
            boolean isBaby = this.subtleEffects$panda.isBaby();
            if ((isBaby || this.subtleEffects$panda.isWeak()) && player.getItemInHand(hand).is(Items.FEATHER)) {
                SoundSource soundSource = this.getSoundSource();
                float pitch = isBaby ? 1.0f : 0.7f;
                player.swing(hand);
                this.subtleEffects$panda.sneeze(true);
                Util.playClientSound((Entity)this.subtleEffects$panda, SoundEvents.PANDA_PRE_SNEEZE, soundSource, 1.0f, pitch);
                TickerManager.schedule(20, () -> {
                    Util.playClientSound((Entity)this.subtleEffects$panda, SoundEvents.PANDA_SNEEZE, soundSource, 1.0f, pitch);
                    if (ModConfigs.ENTITIES.improvedPandaSneezes) {
                        this.subtleEffects$spawnSneezeParticles(level, isBaby);
                        return;
                    }
                    Vec3 deltaMovement = this.subtleEffects$panda.getDeltaMovement();
                    double offset = (double)(this.getBbWidth() + 1.0f) * (isBaby ? 0.5 : 0.7);
                    float rotation = this.yBodyRot * ((float)Math.PI / 180);
                    level.addParticle((ParticleOptions)ParticleTypes.SNEEZE, this.getX() - offset * (double)Mth.sin((float)rotation), this.getEyeY() - (isBaby ? 0.1 : 0.5), this.getZ() + offset * (double)Mth.cos((float)rotation), deltaMovement.x, 0.0, deltaMovement.z);
                });
            }
        }
        return result;
    }

    @WrapOperation(method={"afterSneeze"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V")})
    private void replaceSneezeParticles(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (level.isClientSide && ModConfigs.ENTITIES.improvedPandaSneezes) {
            this.subtleEffects$spawnSneezeParticles(level, this.subtleEffects$panda.isBaby());
            return;
        }
        original.call(new Object[]{level, particle, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @Unique
    private void subtleEffects$spawnSneezeParticles(Level level, boolean isBaby) {
        Vec3 offset = isBaby ? new Vec3(-0.03, -0.33, 0.0) : new Vec3(0.0, -0.35, 0.9);
        for (int i = 0; i < 16; ++i) {
            ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)ModParticles.SNEEZE.get(), (LivingEntity)this.subtleEffects$panda, level, this.random, offset, new Vec3(MathUtil.nextNonAbsDouble(this.random, 0.02), 0.0, Mth.nextDouble((RandomSource)this.random, (double)0.03, (double)0.08)), Util.getPartialTicks());
        }
    }
}

