/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.mixin.client.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import einstein.subtle_effects.init.ModConfigs;
import einstein.subtle_effects.util.ParticleSpawnUtil;
import einstein.subtle_effects.util.Util;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MushroomCow.class})
public class MooshroomMixin {
    @Unique
    private final MushroomCow subtleEffects$me = (MushroomCow)this;

    @WrapOperation(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=0)})
    private void spawnFeedingFailedParticles(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (ModConfigs.ENTITIES.improvedBrownMooshroomFeedingEffects) {
            for (int i = 0; i < 5; ++i) {
                level.addParticle(particle, this.subtleEffects$me.getRandomX(1.0), this.subtleEffects$me.getRandomY(), this.subtleEffects$me.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
            return;
        }
        original.call(new Object[]{level, particle, x, y, z, xSpeed, ySpeed, zSpeed});
    }

    @Inject(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;consume(ILnet/minecraft/world/entity/LivingEntity;)V")})
    private void spawnFeedingParticles(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir, @Local Optional<SuspiciousStewEffects> optional, @Local(ordinal=0) ItemStack heldStack) {
        Level level = this.subtleEffects$me.level();
        RandomSource random = this.subtleEffects$me.getRandom();
        if (ModConfigs.ENTITIES.animalFeedingParticles && !heldStack.isEmpty()) {
            ItemParticleOption options = new ItemParticleOption(ParticleTypes.ITEM, heldStack);
            for (int i = 0; i < 16; ++i) {
                ParticleSpawnUtil.spawnEntityFaceParticle((ParticleOptions)options, (LivingEntity)this.subtleEffects$me, level, random, new Vec3(0.0, 0.3, -0.2), Util.getPartialTicks());
            }
        }
        if (ModConfigs.ENTITIES.improvedBrownMooshroomFeedingEffects) {
            List effects = optional.get().effects();
            int color = ((MobEffect)((SuspiciousStewEffects.Entry)effects.get(random.nextInt(effects.size()))).effect().value()).getColor();
            ColorParticleOption colorOptions = ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color);
            for (int i = 0; i < 8; ++i) {
                level.addParticle((ParticleOptions)colorOptions, this.subtleEffects$me.getRandomX(1.0), this.subtleEffects$me.getRandomY(), this.subtleEffects$me.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
        }
    }

    @WrapOperation(method={"mobInteract"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V", ordinal=1)})
    private void spawnEffectParticles(Level level, ParticleOptions particle, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<Void> original) {
        if (!ModConfigs.ENTITIES.improvedBrownMooshroomFeedingEffects) {
            original.call(new Object[]{level, particle, x, y, z, xSpeed, ySpeed, zSpeed});
        }
    }
}

