/*
 * Decompiled with CFR 0.152.
 */
package einstein.subtle_effects.init;

import einstein.subtle_effects.configs.ModBlockConfigs;
import einstein.subtle_effects.configs.ModEntityConfigs;
import einstein.subtle_effects.configs.ModEnvironmentConfigs;
import einstein.subtle_effects.configs.ModGeneralConfigs;
import einstein.subtle_effects.configs.ModItemConfigs;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.api.RegisterType;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.util.AllowableIdentifiers;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedList;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ModConfigs {
    public static final String BASE_KEY = "config.subtle_effects.";
    public static final ModGeneralConfigs GENERAL = ModConfigs.register(ModGeneralConfigs::new);
    public static final ModBlockConfigs BLOCKS = ModConfigs.register(ModBlockConfigs::new);
    public static final ModEntityConfigs ENTITIES = ModConfigs.register(ModEntityConfigs::new);
    public static final ModEnvironmentConfigs ENVIRONMENT = ModConfigs.register(ModEnvironmentConfigs::new);
    public static final ModItemConfigs ITEMS = ModConfigs.register(ModItemConfigs::new);

    public static void init() {
    }

    private static <T extends Config> T register(Supplier<T> supplier) {
        return (T)ConfigApiJava.registerAndLoadConfig(supplier, (RegisterType)RegisterType.CLIENT);
    }

    public static ValidatedList<ResourceLocation> biomeList(String ... biomeIds) {
        return ModConfigs.registryList(Registries.BIOME, biomeIds);
    }

    public static <T> ValidatedList<ResourceLocation> registryList(ResourceKey<? extends Registry<? extends T>> registryKey, Collection<ResourceLocation> defaultIds) {
        return ModConfigs.registryList(registryKey, (String[])defaultIds.stream().map(ResourceLocation::toString).toArray(String[]::new));
    }

    public static <T> ValidatedList<ResourceLocation> registryList(ResourceKey<? extends Registry<? extends T>> registryKey, String ... defaultIds) {
        return new ValidatedIdentifier(ResourceLocation.withDefaultNamespace((String)"air"), new AllowableIdentifiers(location -> ModConfigs.getRegistry(registryKey).map(biomes -> biomes.containsKey(location)).orElse(true), () -> ModConfigs.getRegistry(registryKey).map(biomes -> biomes.keySet().stream().toList()).orElseGet(List::of))).toList(Arrays.stream(defaultIds).map(ResourceLocation::tryParse).toList());
    }

    private static <T> Optional<Registry<T>> getRegistry(ResourceKey<? extends Registry<? extends T>> registryKey) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return level.registryAccess().registry(registryKey);
        }
        return Optional.empty();
    }
}

