/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals;

import com.mojang.logging.LogUtils;
import com.oierbravo.mechanicals.register.CreateStuff;
import com.oierbravo.mechanicals.register.MechanicalCreativeModeTabs;
import com.oierbravo.mechanicals.register.MechanicalIngredientTypes;
import com.oierbravo.mechanicals.register.MechanicalRecipeRequirementTypes;
import com.oierbravo.mechanicals.register.MechanicalRegistries;
import com.oierbravo.mechanicals.register.MechanicalsFeatureFlags;
import com.oierbravo.mechanicals.utility.RegistrateLangBuilder;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.slf4j.Logger;

@Mod(value="mechanicals")
public class Mechanicals {
    public static final String MODID = "mechanicals";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final NonNullSupplier<Registrate> REGISTRATE = NonNullSupplier.lazy(() -> Registrate.create((String)MODID));

    public Mechanicals(IEventBus modEventBus, ModContainer modContainer) {
        MechanicalsFeatureFlags.init();
        MechanicalCreativeModeTabs.register(modEventBus);
        if (ModList.get().isLoaded("create")) {
            CreateStuff.register();
        }
        modEventBus.addListener(this::newRegistries);
        MechanicalRecipeRequirementTypes.register(modEventBus);
        MechanicalIngredientTypes.register(modEventBus);
        modEventBus.addListener(Mechanicals::gatherData);
        this.generateLangEntries();
    }

    private void generateLangEntries() {
        new RegistrateLangBuilder<Registrate>(MODID, Mechanicals.registrate()).add("ui.progress", "Progress: %d%%").addCreativeTab("Mechanicals").add("mechanicals.feature.lemon_stuff.description", "Enabled Lemon stuff feature for Mechanicals").add("ui.recipe.requirements.title", "Requirements:").add("ui.recipe_requirement.none.tooltip", "None").addRecipeRequirementTitle("biome", "Biome:").addRecipeRequirementValue("biome", "%s").addRecipeRequirementMissing("biome", "Incorrect biome").addRecipeRequirementTitle("biome_tag", "Biome Tag:").addRecipeRequirementValue("biome_tag", "#%s").addRecipeRequirementMissing("biome_tag", "Incorrect biome").addRecipeRequirementTitle("min_y", "Min Y:").addRecipeRequirementValue("min_y", "%s").addRecipeRequirementMissing("min_y", "Y position Too low").addRecipeRequirementTitle("max_y", "Max Y:").addRecipeRequirementValue("max_y", "%s").addRecipeRequirementMissing("max_y", "Y position Too high").addRecipeRequirementTitle("min_speed", "Min Speed:").addRecipeRequirementValue("min_speed", "%s RPM").addRecipeRequirementMissing("min_speed", "Not enough speed").addRecipeRequirementTitle("max_speed", "Max Speed:").addRecipeRequirementMissing("max_speed", "Too fast").addRecipeRequirementValue("max_speed", "%s RPM").addRecipeRequirementMissing("output", "Output full or incompatible").addRecipeRequirementMissing("ingredients", "Missing ingredients");
    }

    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            // empty if block
        }
    }

    public static void addFeaturePacks(AddPackFindersEvent event) {
        event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"data/mechanicals/datapacks/lemon_stuff"), PackType.SERVER_DATA, (Component)Component.literal((String)"Mechanicals: Lemon stuff"), PackSource.FEATURE, false, Pack.Position.TOP);
    }

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.get();
    }

    private void newRegistries(NewRegistryEvent event) {
        MechanicalRegistries.register(event);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

