/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.utils;

import io.wispforest.accessories.utils.WrappingCollection;
import io.wispforest.accessories.utils.WrappingSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidatingForwardingMap<K, V>
implements Map<K, V> {
    private final Map<K, V> innerMap;
    private final Class<K> clazzK;
    private final Class<V> clazzV;
    private final Predicate<K> keyValidator;
    private final Function<V, K> keyGetter;
    private Set<K> keySet = null;
    private Collection<V> values = null;
    private Set<Map.Entry<K, V>> entrySet = null;

    public ValidatingForwardingMap(Map<K, V> innerMap, Class<K> clazzK, Class<V> clazzV, Predicate<K> keyValidator, Function<V, K> keyGetter) {
        this.innerMap = innerMap;
        this.clazzK = clazzK;
        this.clazzV = clazzV;
        this.keyValidator = keyValidator;
        this.keyGetter = keyGetter;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.clazzK.isInstance(key) && this.keyValidator.test(key) && this.innerMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.clazzV.isInstance(value) && this.keyValidator.test(this.keyGetter.apply(value)) && this.innerMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.clazzK.isInstance(key) && this.keyValidator.test(key) ? (V)this.innerMap.get(key) : null;
    }

    @Override
    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new WrappingSet<Object, Set<K>>(this.innerMap.keySet(), o -> this.clazzK.isInstance(o) ? o : null, this.keyValidator);
        }
        return this.keySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new WrappingCollection<Object, Collection<V>>(this.innerMap.values(), o -> this.clazzV.isInstance(o) ? o : null, v -> this.keyValidator.test(this.keyGetter.apply(v)));
        }
        return this.values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = WrappingSet.of(this.innerMap.entrySet(), this.clazzK, this.keyValidator);
        }
        return this.entrySet;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        ValidatingForwardingMap.throwUnsupported("replaceAll");
    }

    @Override
    @Nullable
    public V putIfAbsent(K key, V value) {
        return (V)ValidatingForwardingMap.throwUnsupported("putIfAbsent");
    }

    @Override
    public boolean remove(Object key, Object value) {
        return (Boolean)ValidatingForwardingMap.throwUnsupported("remove");
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return (Boolean)ValidatingForwardingMap.throwUnsupported("replace");
    }

    @Override
    @Nullable
    public V replace(K key, V value) {
        return (V)ValidatingForwardingMap.throwUnsupported("replace");
    }

    @Override
    public V computeIfAbsent(K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        return (V)ValidatingForwardingMap.throwUnsupported("computeIfAbsent");
    }

    @Override
    public V computeIfPresent(K key, @NotNull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return (V)ValidatingForwardingMap.throwUnsupported("computeIfPresent");
    }

    @Override
    public V compute(K key, @NotNull BiFunction<? super K, ? super @Nullable V, ? extends V> remappingFunction) {
        return (V)ValidatingForwardingMap.throwUnsupported("compute");
    }

    @Override
    public V merge(K key, @NotNull V value, @NotNull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)ValidatingForwardingMap.throwUnsupported("merge");
    }

    @Override
    public V put(K key, V value) {
        return (V)ValidatingForwardingMap.throwUnsupported("put");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        ValidatingForwardingMap.throwUnsupported("putAll");
    }

    @Override
    public void clear() {
        ValidatingForwardingMap.throwUnsupported("clear");
    }

    @Override
    public V remove(Object key) {
        return (V)ValidatingForwardingMap.throwUnsupported("remove");
    }

    private static <T> T throwUnsupported(String methodName) {
        throw new UnsupportedOperationException("Unable to use '" + methodName + "' as such is not support as its Immutable!");
    }
}

