/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.data.AccessoriesTags;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Shadow
    protected static void runIterationOnItem(ItemStack itemStack, EquipmentSlot equipmentSlot, LivingEntity livingEntity, EnchantmentHelper.EnchantmentInSlotVisitor enchantmentInSlotVisitor) {
    }

    @WrapOperation(method={"getEnchantmentLevel(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/LivingEntity;)I"}, at={@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;")})
    private static Collection<ItemStack> addAccessoriesStacks(Map instance, Operation<Collection<ItemStack>> original, @Local(argsOnly=true) Holder<Enchantment> enchantment, @Local(argsOnly=true) LivingEntity entity) {
        ArrayList<ItemStack> returnValue = new ArrayList<ItemStack>((Collection)original.call(new Object[]{instance}));
        AccessoriesCapability capability = entity.accessoriesCapability();
        if (capability != null) {
            returnValue.addAll(capability.getAllEquipped().stream().map(SlotEntryReference::stack).toList());
        }
        return returnValue;
    }

    @Inject(method={"getRandomItemWith(Lnet/minecraft/core/component/DataComponentType;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Predicate;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;getRandom()Lnet/minecraft/util/RandomSource;")})
    private static void adjustListForAccessories(DataComponentType<?> dataComponentType, LivingEntity livingEntity, Predicate<ItemStack> predicate, CallbackInfoReturnable<Optional<EnchantedItemInUse>> cir, @Local(ordinal=0) List<EnchantedItemInUse> list) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability != null) {
            List<EnchantedItemInUse> allEquippedAccessories = capability.getAllEquipped().stream().filter(entryReference -> {
                ItemStack itemStack = entryReference.stack();
                if (predicate.test(entryReference.stack())) {
                    ItemEnchantments itemEnchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                    for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                        Holder holder = (Holder)entry.getKey();
                        if (!((Enchantment)holder.value()).effects().has(dataComponentType) || !EnchantmentHelperMixin.enchantmentValidForRedirect(livingEntity.registryAccess(), (Enchantment)holder.value())) continue;
                        return true;
                    }
                }
                return false;
            }).map(entryReference -> new EnchantedItemInUse(entryReference.stack(), AccessoriesInternals.INTERNAL_SLOT, livingEntity, item -> AccessoriesAPI.breakStack(entryReference.reference()))).toList();
            list.addAll(allEquippedAccessories);
        }
    }

    @Inject(method={"runIterationOnEquipment(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="TAIL")})
    private static void adjustIterationWithAccessories(LivingEntity livingEntity, EnchantmentHelper.EnchantmentInSlotVisitor enchantmentInSlotVisitor, CallbackInfo ci) {
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        if (capability != null) {
            capability.getAllEquipped().forEach(entryReference -> {
                ItemStack itemStack = entryReference.stack();
                EnchantmentHelperMixin.runIterationOnItem(itemStack, AccessoriesInternals.INTERNAL_SLOT, livingEntity, enchantmentInSlotVisitor);
            });
        }
    }

    @ModifyExpressionValue(method={"runIterationOnItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/EquipmentSlot;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/enchantment/EnchantmentHelper$EnchantmentInSlotVisitor;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/Enchantment;matchingSlot(Lnet/minecraft/world/entity/EquipmentSlot;)Z")})
    private static boolean adjustIfIterationOccurs(boolean original, @Local(argsOnly=true) EquipmentSlot equipmentSlot, @Local(argsOnly=true) LivingEntity livingEntity, @Local(ordinal=0) Holder<Enchantment> holder) {
        if (equipmentSlot.equals((Object)AccessoriesInternals.INTERNAL_SLOT) && EnchantmentHelperMixin.enchantmentValidForRedirect(livingEntity.registryAccess(), (Enchantment)holder.value())) {
            return true;
        }
        return original;
    }

    @Unique
    private static boolean enchantmentValidForRedirect(RegistryAccess access, Enchantment enchantment) {
        Registry enchantments = (Registry)access.registry(Registries.ENCHANTMENT).orElseThrow();
        return !((Holder.Reference)enchantments.getHolder((ResourceKey)enchantments.getResourceKey((Object)enchantment).orElseThrow()).orElseThrow()).is(AccessoriesTags.INVALID_FOR_REDIRECTION);
    }
}

