/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.slot;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.SlotTypeReference;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

public class UniqueSlotHandling {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Event<RegistrationCallback> EVENT = EventFactory.createArrayBacked(RegistrationCallback.class, invokers -> factory -> {
        for (RegistrationCallback invoker : invokers) {
            invoker.registerSlots(factory);
        }
    });
    private static final Map<String, Set<EntityType<?>>> SLOT_TO_ENTITIES = new HashMap();
    private static final Set<String> GROUPS_SERVER = new LinkedHashSet<String>();
    private static final Set<String> GROUPS_CLIENT = new LinkedHashSet<String>();

    public static boolean isUniqueSlot(String slotType) {
        return slotType.split(":").length > 1;
    }

    public static boolean isUniqueGroup(String group, boolean isClient) {
        return (isClient ? GROUPS_CLIENT : GROUPS_SERVER).contains(group);
    }

    @ApiStatus.Internal
    public static void gatherUniqueSlots(TriFunction<ResourceLocation, Integer, Collection<ResourceLocation>, SlotTypeReference> slotRegistration) {
        GROUPS_SERVER.clear();
        SLOT_TO_ENTITIES.clear();
        UniqueSlotBuilderFactory eventRegistration = (location, amount) -> new ServerUniqueSlotBuilder(location, amount, slotRegistration);
        ((RegistrationCallback)EVENT.invoker()).registerSlots(eventRegistration);
    }

    @ApiStatus.Internal
    public static void buildClientSlotReferences() {
        UniqueSlotBuilderFactory eventRegistration = (location, amount) -> new UniqueSlotBuilder(){

            @Override
            public UniqueSlotBuilder slotPredicates(ResourceLocation ... locations) {
                return this;
            }

            @Override
            public UniqueSlotBuilder validTypes(EntityType<?> ... types) {
                return this;
            }

            @Override
            public UniqueSlotBuilder strictMode(boolean value) {
                return this;
            }

            @Override
            public UniqueSlotBuilder allowResizing(boolean value) {
                return this;
            }

            @Override
            public UniqueSlotBuilder allowEquipFromUse(boolean value) {
                return this;
            }

            @Override
            public UniqueSlotBuilder allowTooltipInfo(boolean value) {
                return this;
            }

            @Override
            public SlotTypeReference build() {
                String name = location.toString();
                SlotType slotType = SlotTypeLoader.INSTANCE.getSlotTypes(true).get(name);
                if (slotType == null) {
                    LOGGER.error("Unable to get the given unique slot as the slot has been not been synced to the client! [Name: {}]", (Object)name);
                }
                return new SlotTypeReference(name);
            }
        };
        ((RegistrationCallback)EVENT.invoker()).registerSlots(eventRegistration);
    }

    @ApiStatus.Internal
    public static Map<String, Set<EntityType<?>>> getSlotToEntities() {
        return ImmutableMap.copyOf(SLOT_TO_ENTITIES);
    }

    @ApiStatus.Internal
    public static void addGroup(String group) {
        GROUPS_SERVER.add(group);
    }

    @ApiStatus.Internal
    public static Set<String> getGroups(boolean isClient) {
        return isClient ? GROUPS_CLIENT : GROUPS_SERVER;
    }

    @ApiStatus.Internal
    public static void setClientGroups(Collection<String> set) {
        GROUPS_CLIENT.clear();
        GROUPS_CLIENT.addAll(set);
    }

    public static interface UniqueSlotBuilderFactory {
        public UniqueSlotBuilder create(ResourceLocation var1, int var2);
    }

    public static interface RegistrationCallback {
        public void registerSlots(UniqueSlotBuilderFactory var1);
    }

    private static final class ServerUniqueSlotBuilder
    implements UniqueSlotBuilder {
        private final ResourceLocation location;
        private final int amount;
        private Set<ResourceLocation> slotPredicates = Set.of(Accessories.of("tag"));
        private Set<EntityType<?>> validTypes = Set.of();
        private boolean strictMode = true;
        private boolean allowResizing = false;
        private boolean allowEquipFromUse = true;
        private boolean allowTooltipInfo = true;
        private final TriFunction<ResourceLocation, Integer, Collection<ResourceLocation>, SlotTypeReference> slotRegistration;

        ServerUniqueSlotBuilder(ResourceLocation location, int amount, TriFunction<ResourceLocation, Integer, Collection<ResourceLocation>, SlotTypeReference> slotRegistration) {
            this.location = location;
            this.amount = amount;
            this.slotRegistration = slotRegistration;
        }

        @Override
        public ServerUniqueSlotBuilder slotPredicates(ResourceLocation ... locations) {
            this.slotPredicates = Set.of(locations);
            return this;
        }

        @Override
        public ServerUniqueSlotBuilder validTypes(EntityType<?> ... types) {
            this.validTypes = Set.of(types);
            return this;
        }

        @Override
        public ServerUniqueSlotBuilder strictMode(boolean value) {
            this.strictMode = value;
            return this;
        }

        @Override
        public ServerUniqueSlotBuilder allowResizing(boolean value) {
            this.allowResizing = value;
            return this;
        }

        @Override
        public ServerUniqueSlotBuilder allowEquipFromUse(boolean value) {
            this.allowEquipFromUse = value;
            return this;
        }

        @Override
        public UniqueSlotBuilder allowTooltipInfo(boolean value) {
            this.allowTooltipInfo = value;
            return this;
        }

        @Override
        public SlotTypeReference build() {
            SlotTypeReference slotTypeRef = (SlotTypeReference)this.slotRegistration.apply((Object)this.location, (Object)this.amount, this.slotPredicates);
            SLOT_TO_ENTITIES.put(slotTypeRef.slotName(), Set.copyOf(this.validTypes));
            ExtraSlotTypeProperties.getProperties(false).put(slotTypeRef.slotName(), new ExtraSlotTypeProperties(this.allowResizing, this.strictMode, this.allowEquipFromUse, this.allowTooltipInfo));
            return slotTypeRef;
        }
    }

    public static interface UniqueSlotBuilder {
        public UniqueSlotBuilder slotPredicates(ResourceLocation ... var1);

        public UniqueSlotBuilder validTypes(EntityType<?> ... var1);

        public UniqueSlotBuilder strictMode(boolean var1);

        public UniqueSlotBuilder allowResizing(boolean var1);

        public UniqueSlotBuilder allowEquipFromUse(boolean var1);

        public UniqueSlotBuilder allowTooltipInfo(boolean var1);

        public SlotTypeReference build();
    }
}

